/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.util;

import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class BinaryFilePathValidator
implements IValidator {
    public IStatus validate(Object valueAsObject) {
        String value = (String)valueAsObject;
        if (value == null) {
            return this.getErrorStatus("File path has not been specified");
        }
        Path filePath = null;
        try {
            filePath = FileSystems.getDefault().getPath(value, new String[0]);
        }
        catch (InvalidPathException e) {
            return this.getErrorStatus("Invalid file path: " + e.getMessage());
        }
        if (!filePath.toFile().isFile()) {
            return this.getErrorStatus("This is not a (normal) file");
        }
        if (!filePath.toFile().canRead()) {
            return this.getErrorStatus("Can't read specified file");
        }
        if (!filePath.toFile().canExecute()) {
            return this.getErrorStatus("Can't execute specified file");
        }
        return Status.OK_STATUS;
    }

    private IStatus getErrorStatus(String errorMsg) {
        return new Status(4, "unknown plugin id", 42, errorMsg, null);
    }
}

