/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.conf_folder_manager;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class ConfFolderManager {
    public static final String GUI_INSTALL_TIMESTAMP_FILE_FILE_NAME = "gui_install_timestamp";
    private static Path installTimestampFileInInstallFolderFilePath;
    private static Path confFolderPath;
    private static Path installTimestampFileInConfFolderFilePath;

    public static void main(String[] args) throws IOException {
        installTimestampFileInInstallFolderFilePath = FileSystems.getDefault().getPath(GUI_INSTALL_TIMESTAMP_FILE_FILE_NAME, new String[0]);
        confFolderPath = FileSystems.getDefault().getPath(System.getProperty("user.home"), "neopop-gui", "conf");
        installTimestampFileInConfFolderFilePath = confFolderPath.resolve(GUI_INSTALL_TIMESTAMP_FILE_FILE_NAME);
        ConfFolderManager.checkTimestampFileInConfFolder();
    }

    private static void checkTimestampFileInConfFolder() throws IOException {
        if (!installTimestampFileInConfFolderFilePath.toFile().exists()) {
            ConfFolderManager.wipeConfFolder();
            ConfFolderManager.copyTimestampFileFromInstallToConfFolder();
        } else {
            String timeStampInConfFolder;
            String timeStampInInstallFolder = ConfFolderManager.readTimeStamp(installTimestampFileInInstallFolderFilePath);
            if (!timeStampInInstallFolder.equals(timeStampInConfFolder = ConfFolderManager.readTimeStamp(installTimestampFileInConfFolderFilePath))) {
                ConfFolderManager.wipeConfFolder();
                ConfFolderManager.copyTimestampFileFromInstallToConfFolder();
            }
        }
    }

    private static void wipeConfFolder() throws IOException {
        if (confFolderPath.toFile().exists()) {
            Files.walkFileTree(confFolderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return super.visitFile(file, attrs);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!dir.equals(confFolderPath)) {
                        Files.delete(dir);
                    }
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
    }

    private static void copyTimestampFileFromInstallToConfFolder() throws IOException {
        Files.createDirectories(confFolderPath, new FileAttribute[0]);
        Files.copy(installTimestampFileInInstallFolderFilePath, installTimestampFileInConfFolderFilePath, new CopyOption[0]);
    }

    private static String readTimeStamp(Path timeStampFileFilePath) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(timeStampFileFilePath.toFile()));
        String timeStamp = br.readLine();
        br.close();
        return timeStamp;
    }
}

