/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import de.tu_bs.ilr.esa.estec.neopop.model.BasePathType;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElementContainer;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawOptModule;
import de.tu_bs.ilr.esa.estec.neopop.model.OpticalTelescopeErrorRate;
import de.tu_bs.ilr.esa.estec.neopop.model.OpticalTelescopeType;
import de.tu_bs.ilr.esa.estec.neopop.model.Sensor;
import de.tu_bs.ilr.esa.estec.neopop.model.VarUsage;
import de.tu_bs.ilr.esa.estec.neopop.model.Vars;

public class OpticalSensor
extends Sensor {
    public static final String PROP_TYPE = "type";
    public static final String PROP_FIELD_OF_VIEW = "fieldOfView";
    public static final String PROP_INTEGRATION_TIME = "integrationTime";
    public static final String PROP_GAP_TIME = "gapTime";
    public static final String PROP_MIN_NUMBER_OF_CONSECUTIVE_DETECTIONS = "minNumberOfConsecutiveDetections";
    public static final String PROP_LIMITING_MAGNITUDE = "limitingMagnitude";
    public static final String PROP_DIAMETER_OF_APERATURE = "diameterOfAperature";
    public static final String PROP_PIXEL_SIZE = "pixelSize";
    public static final String PROP_NUMBER_OF_PIXELS_PER_ROW = "numberOfPixelsPerRow";
    public static final String PROP_SCALE = "scale";
    public static final String PROP_FULL_WIDTH_HALF_MAXIMUM = "fullWidthHalfMaximum";
    public static final String PROP_THRESHOLD_PARAMETER_FOR_DETECTION = "thresholdParameterForDetection";
    public static final String PROP_COUNT_RATE_CONSTANT_FOR_CCD_READOUT_NOISE = "countRateContantForCcdReadoutNoise";
    public static final String PROP_COUNT_RATE_CONSTANT_FOR_DARK_NOISE = "countRateContantForDarkNoise";
    public static final String PROP_ISR_FILENAME = "isrFilename";
    public static final String PROP_AZIMUTH_ERROR_RATE = "azimuthErrorRate";
    public static final String PROP_ELEVATION_ERROR_RATE = "elevationErrorRate";
    protected VarUsage<OpticalTelescopeType> type = new VarUsage<OpticalTelescopeType>((InputElement)this, Vars.OPTICAL_TELESCOPE_TYPE, "type", OpticalTelescopeType.VISIBLE_LIGHT, new int[0]);
    protected VarUsage<Double> fieldOfView = new VarUsage<Double>((InputElement)this, Vars.OPTICAL_TELESCOPE_FIELD_OF_VIEW, "fieldOfView", 0.709, new int[0]);
    protected VarUsage<Double> integrationTime = new VarUsage<Double>((InputElement)this, Vars.INTEGRATION_TIME, "integrationTime", 2.0, new int[0]);
    protected VarUsage<Double> gapTime = new VarUsage<Double>((InputElement)this, Vars.GAP_TIME, "gapTime", 58.0, new int[0]);
    protected VarUsage<Integer> minNumberOfConsecutiveDetections = new VarUsage<Integer>((InputElement)this, Vars.MIN_NUMBER_OF_CONSECUTIVE_DETECTION, "minNumberOfConsecutiveDetections", Integer.valueOf(2), null);
    protected VarUsage<Double> limitingMagnitude = new VarUsage<Double>((InputElement)this, Vars.LIMITING_MAGNITUDE, "limitingMagnitude", 17.0, new int[0]);
    protected VarUsage<Double> diameterOfAperature = new VarUsage<Double>((InputElement)this, Vars.DIAMETER_OF_APERTURE, "diameterOfAperature", 1.016, new int[0]);
    protected VarUsage<Double> pixelSize = new VarUsage<Double>((InputElement)this, Vars.PIXEL_SIZE, "pixelSize", 17.0, new int[0]);
    protected VarUsage<Integer> numberOfPixelsPerRow = new VarUsage<Integer>((InputElement)this, Vars.NUMBER_OF_PIXELS_PER_ROW, "numberOfPixelsPerRow", Integer.valueOf(2048), null);
    protected VarUsage<Double> scale = new VarUsage<Double>((InputElement)this, Vars.SCALE, "scale", 1.24, new int[0]);
    protected VarUsage<Double> fullWidthHalfMaximum = new VarUsage<Double>((InputElement)this, Vars.FULL_WIDTH_HALF_MAXIMUM, "fullWidthHalfMaximum", 1.21, new int[0]);
    protected VarUsage<Double> thresholdParameterForDetection = new VarUsage<Double>((InputElement)this, Vars.THRESHOLD_PARAMETER_FOR_DETECTION, "thresholdParameterForDetection", 2.1, new int[0]);
    protected VarUsage<Double> countRateContantForCcdReadoutNoise = new VarUsage<Double>((InputElement)this, Vars.COUNT_RATE_CONSTANT_FOR_CCD_READOUT_NOISE, "countRateContantForCcdReadoutNoise", 8.0, new int[0]);
    protected VarUsage<Double> countRateContantForDarkNoise = new VarUsage<Double>((InputElement)this, Vars.COUNT_RATE_CONTANT_FOR_DARK_NOISE, "countRateContantForDarkNoise", 0.0, new int[0]);
    protected VarUsage<String> isrFilename = new VarUsage<String>((InputElement)this, Vars.ISR_FILENAME, "isrFilename", "file.ops", new int[0]);
    protected InputElementContainer<OpticalTelescopeErrorRate> azimuthErrorRate = new InputElementContainer<OpticalTelescopeErrorRate>(this, "azimuthErrorRate", new OpticalTelescopeErrorRate(this, 1));
    protected InputElementContainer<OpticalTelescopeErrorRate> elevationErrorRate = new InputElementContainer<OpticalTelescopeErrorRate>(this, "elevationErrorRate", new OpticalTelescopeErrorRate(this, 2));

    protected OpticalSensor(ObsSimRawOptModule parent, int opticalTelescopeIndex) {
        super((InputElement)parent, Vars.OPTICAL_TELESCOPE_NAME, "New Optical Sensor", opticalTelescopeIndex);
        this.setBasePath(PROP_ISR_FILENAME, BasePathType.TOOL_EXEC_DIR);
    }

    public OpticalTelescopeType getType() {
        return this.type.get();
    }

    public void setType(OpticalTelescopeType type) {
        this.type.set(type);
    }

    public boolean checkType(OpticalTelescopeType type) {
        return this.type.check(type);
    }

    public Double getFieldOfView() {
        return this.fieldOfView.get();
    }

    public void setFieldOfView(Double fieldOfView) {
        this.fieldOfView.set(fieldOfView);
    }

    public boolean checkFieldOfView(Double fieldOfView) {
        return this.fieldOfView.check(fieldOfView);
    }

    public Double getIntegrationTime() {
        return this.integrationTime.get();
    }

    public void setIntegrationTime(Double integrationTime) {
        this.integrationTime.set(integrationTime);
    }

    public boolean checkIntegrationTime(Double integrationTime) {
        return this.integrationTime.check(integrationTime);
    }

    public Double getGapTime() {
        return this.gapTime.get();
    }

    public void setGapTime(Double gapTime) {
        this.gapTime.set(gapTime);
    }

    public boolean checkGapTime(Double gapTime) {
        return this.gapTime.check(gapTime);
    }

    public Integer getMinNumberOfConsecutiveDetections() {
        return this.minNumberOfConsecutiveDetections.get();
    }

    public void setMinNumberOfConsecutiveDetections(Integer minNumberOfConsecutiveDetections) {
        this.minNumberOfConsecutiveDetections.set(minNumberOfConsecutiveDetections);
    }

    public boolean checkMinNumberOfConsecutiveDetections(Integer minNumberOfConsecutiveDetections) {
        return this.minNumberOfConsecutiveDetections.check(minNumberOfConsecutiveDetections);
    }

    public Double getLimitingMagnitude() {
        return this.limitingMagnitude.get();
    }

    public void setLimitingMagnitude(Double limitingMagnitude) {
        this.limitingMagnitude.set(limitingMagnitude);
    }

    public boolean checkLimitingMagnitude(Double limitingMagnitude) {
        return this.limitingMagnitude.check(limitingMagnitude);
    }

    public Double getDiameterOfAperature() {
        return this.diameterOfAperature.get();
    }

    public void setDiameterOfAperature(Double diameterOfAperature) {
        this.diameterOfAperature.set(diameterOfAperature);
    }

    public boolean checkDiameterOfAperature(Double diameterOfAperature) {
        return this.diameterOfAperature.check(diameterOfAperature);
    }

    public Double getPixelSize() {
        return this.pixelSize.get();
    }

    public void setPixelSize(Double pixelSize) {
        this.pixelSize.set(pixelSize);
    }

    public boolean checkPixelSize(Double pixelSize) {
        return this.pixelSize.check(pixelSize);
    }

    public Integer getNumberOfPixelsPerRow() {
        return this.numberOfPixelsPerRow.get();
    }

    public void setNumberOfPixelsPerRow(Integer numberOfPixelsPerRow) {
        this.numberOfPixelsPerRow.set(numberOfPixelsPerRow);
    }

    public boolean checkNumberOfPixelsPerRow(Integer numberOfPixelsPerRow) {
        return this.numberOfPixelsPerRow.check(numberOfPixelsPerRow);
    }

    public Double getScale() {
        return this.scale.get();
    }

    public void setScale(Double scale) {
        this.scale.set(scale);
    }

    public boolean checkScale(Double scale) {
        return this.scale.check(scale);
    }

    public Double getFullWidthHalfMaximum() {
        return this.fullWidthHalfMaximum.get();
    }

    public void setFullWidthHalfMaximum(Double fullWidthHalfMaximum) {
        this.fullWidthHalfMaximum.set(fullWidthHalfMaximum);
    }

    public boolean checkFullWidthHalfMaximum(Double fullWidthHalfMaximum) {
        return this.fullWidthHalfMaximum.check(fullWidthHalfMaximum);
    }

    public Double getThresholdParameterForDetection() {
        return this.thresholdParameterForDetection.get();
    }

    public void setThresholdParameterForDetection(Double thresholdParameterForDetection) {
        this.thresholdParameterForDetection.set(thresholdParameterForDetection);
    }

    public boolean checkThresholdParameterForDetection(Double thresholdParameterForDetection) {
        return this.thresholdParameterForDetection.check(thresholdParameterForDetection);
    }

    public Double getCountRateContantForCcdReadoutNoise() {
        return this.countRateContantForCcdReadoutNoise.get();
    }

    public void setCountRateContantForCcdReadoutNoise(Double countRateContantForCcdReadoutNoise) {
        this.countRateContantForCcdReadoutNoise.set(countRateContantForCcdReadoutNoise);
    }

    public boolean checkCountRateContantForCcdReadoutNoise(Double countRateContantForCcdReadoutNoise) {
        return this.countRateContantForCcdReadoutNoise.check(countRateContantForCcdReadoutNoise);
    }

    public Double getCountRateContantForDarkNoise() {
        return this.countRateContantForDarkNoise.get();
    }

    public void setCountRateContantForDarkNoise(Double countRateContantForDarkNoise) {
        this.countRateContantForDarkNoise.set(countRateContantForDarkNoise);
    }

    public boolean checkCountRateContantForDarkNoise(Double countRateContantForDarkNoise) {
        return this.countRateContantForDarkNoise.check(countRateContantForDarkNoise);
    }

    public String getIsrFilename() {
        return this.isrFilename.get();
    }

    public void setIsrFilename(String isrFilename) {
        this.isrFilename.set(isrFilename);
    }

    public boolean checkIsrFilename(String isrFilename) {
        return this.isrFilename.check(isrFilename);
    }

    public OpticalTelescopeErrorRate getAzimuthErrorRate() {
        return this.azimuthErrorRate.getElement();
    }

    public OpticalTelescopeErrorRate getElevationErrorRate() {
        return this.elevationErrorRate.getElement();
    }
}

