/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import de.tu_bs.ilr.esa.estec.neopop.model.CompleteVarIndexes;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElementCreator;
import de.tu_bs.ilr.esa.estec.neopop.model.internal.Var;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputElementListContainer<T extends InputElement> {
    private final int maxElements;
    private int nextFortranIndex = 1;
    protected List<T> list = new ArrayList<T>();
    private InputElement parent;
    private Logger logger;
    private InputElementCreator<T> elCreator;
    private boolean synchronising;
    private String property;
    private Var<Integer> numberOfElementsVar = null;

    public InputElementListContainer(InputElement parent, int maxElements, InputElementCreator<T> elCreator, String property) {
        this.maxElements = maxElements;
        this.parent = parent;
        this.elCreator = elCreator;
        this.property = property;
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.parent.elListContainers.add(this);
    }

    public InputElementListContainer(InputElement parent, int maxElements, InputElementCreator<T> elCreator, String property, Var<Integer> numberOfElementsVar) {
        this(parent, maxElements, elCreator, property);
        this.numberOfElementsVar = numberOfElementsVar;
    }

    public List<T> get() {
        return this.list;
    }

    public synchronized T add() {
        this.logger.trace("add()");
        this.logger.debug("Adding element to list \"{}\" of {}", (Object)this.property, (Object)this.parent);
        if (this.list.size() == this.maxElements) {
            this.logger.error("Cannot create new element: Maximum={} reached", (Object)this.maxElements);
            return null;
        }
        if (this.nextFortranIndex > this.maxElements) {
            this.doDefragmentate();
        }
        ArrayList<T> oldList = new ArrayList<T>(this.list);
        T newEl = this.elCreator.create(this.nextFortranIndex++);
        if (!this.synchronising) {
            this.logger.debug("Setting default values for new element");
            ((InputElement)newEl).setDefaultValues();
            if (this.numberOfElementsVar != null) {
                this.numberOfElementsVar.set(this.parent.connector, new CompleteVarIndexes(this.parent.indexes, new int[0]), this.numberOfElementsVar.get(this.parent.connector, new CompleteVarIndexes(this.parent.indexes, new int[0])) + 1);
            }
        }
        this.list.add(newEl);
        this.parent.pcs.fireIndexedPropertyChange(this.property, this.list.size() - 1, oldList, this.list);
        return newEl;
    }

    public boolean remove(T value) {
        this.logger.trace("remove(value={})", value);
        ArrayList<T> old = new ArrayList<T>(this.list);
        int index = this.list.indexOf(value);
        this.logger.debug("Removing element from list \"{}\" of {}", (Object)this.property, (Object)this.parent);
        boolean removed = this.list.remove(value);
        if (!this.synchronising && removed && this.numberOfElementsVar != null) {
            this.numberOfElementsVar.set(this.parent.connector, new CompleteVarIndexes(this.parent.indexes, new int[0]), this.numberOfElementsVar.get(this.parent.connector, new CompleteVarIndexes(this.parent.indexes, new int[0])) - 1);
        }
        this.parent.pcs.fireIndexedPropertyChange(this.property, index, old, this.list);
        return removed;
    }

    public void synchElementsWithFortran() {
        this.logger.trace("synchElementsWithFortran()");
        this.synchronising = true;
        ArrayList<T> old = new ArrayList<T>(this.list);
        for (InputElement el : old) {
            this.remove(el);
        }
        this.nextFortranIndex = 1;
        int howMany = this.numberOfElementsVar != null ? this.numberOfElementsVar.get(this.parent.connector, new CompleteVarIndexes(this.parent.indexes, new int[0])) : this.maxElements;
        int i = 0;
        while (i < howMany) {
            ((InputElement)this.add()).synchIndexedPropertiesWithFortran();
            ++i;
        }
        this.synchronising = false;
    }

    protected void doDefragmentate() {
        this.logger.debug("Defragmentating");
        this.nextFortranIndex = 1;
        for (InputElement el : this.list) {
            if (el.indexes.getIndexes().get(el.indexes.getIndexes().size() - 1).getValue() != this.nextFortranIndex) {
                el.newLastIndex(this.nextFortranIndex);
            }
            ++this.nextFortranIndex;
        }
    }

    public void loadTempValues() {
        for (InputElement el : this.list) {
            el.loadTempValues();
        }
    }

    public void saveTempValues() {
        for (InputElement el : this.list) {
            el.saveTempValues();
        }
    }

    public void setDefaultValues() {
        for (InputElement el : this.list) {
            el.setDefaultValues();
        }
    }

    public void defragmentate() {
        this.doDefragmentate();
        for (InputElement el : this.list) {
            el.defragmentateLists();
        }
    }

    public void checkChangeAgainstTempValues() {
        for (InputElement el : this.list) {
            el.checkChangeAgainstTempValuesAndCheckDependencies();
        }
    }
}

