/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.util;

import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelValidator
implements IValidator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ModelElement modelObject = null;
    private WritableValue modelObjectContainer = null;
    private Method checkMethod;
    private String propertyName;
    private Method setMethod;
    private boolean additionallySetInvalidValues = false;

    public ModelValidator(Object object, String propertyName) {
        this.logger.trace("ModelValidator(object={}, propertyName={})", object, (Object)propertyName);
        Assert.isNotNull((Object)object, (String)"object");
        Assert.isNotNull((Object)object, (String)"propertyName");
        this.propertyName = propertyName;
        if (object instanceof WritableValue) {
            this.modelObjectContainer = (WritableValue)object;
            if (this.modelObjectContainer.getValue() != null) {
                this.obtainCheckMethod(this.modelObjectContainer.getValue());
            }
        } else {
            this.modelObject = (ModelElement)object;
            this.obtainCheckMethod(this.modelObject);
        }
    }

    private void obtainCheckMethod(Object modelObject) {
        this.logger.trace("obtainCheckMethod(modelObject={})", modelObject);
        char firstPropCharUpCase = Character.toUpperCase(this.propertyName.charAt(0));
        String checkMethodName = "check" + firstPropCharUpCase + this.propertyName.substring(1);
        String setMethodName = "set" + firstPropCharUpCase + this.propertyName.substring(1);
        this.obtainCheckMethod(modelObject.getClass(), checkMethodName, setMethodName);
        if (this.checkMethod == null) {
            this.logger.error("Cannot find check method for model object {} and property {}", new Object[]{modelObject, this.propertyName, new IllegalArgumentException()});
            this.logger.info("Note: check method must be named \"{}\"", (Object)checkMethodName);
            this.logger.info("Note: check method must take exactly one parameter");
            this.logger.info("Note: check method must return boolean");
        } else {
            this.logger.debug("Found check method: {}", (Object)this.checkMethod);
        }
    }

    private void obtainCheckMethod(Class<?> clazz, String checkMethodName, String setMethodName) {
        if (clazz == null) {
            return;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(checkMethodName) && method.getParameterTypes().length == 1 && method.getReturnType() == Boolean.TYPE) {
                this.checkMethod = method;
            }
            if (method.getName().equals(setMethodName) && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE) {
                this.setMethod = method;
            }
            ++n2;
        }
        this.obtainCheckMethod(clazz.getSuperclass(), checkMethodName, setMethodName);
    }

    public IStatus validate(Object value) {
        this.logger.trace("validate(value={})", value);
        if (this.modelObjectContainer != null && this.checkMethod == null) {
            this.obtainCheckMethod(this.modelObjectContainer.getValue());
        }
        Object modelObject = this.modelObject != null ? this.modelObject : this.modelObjectContainer.getValue();
        Boolean checkResult = null;
        try {
            if (modelObject != null) {
                checkResult = (Boolean)this.checkMethod.invoke(modelObject, value);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not invoke check method {} for model object {}", new Object[]{this.checkMethod, modelObject, e});
        }
        if (checkResult == null || !checkResult.booleanValue()) {
            String errorMsg;
            if (checkResult == null) {
                this.logger.error("Check result is null");
            }
            if (this.additionallySetInvalidValues && modelObject != null) {
                try {
                    if (modelObject instanceof InputElement) {
                        ((InputElement)modelObject).setSuppressEvents(true);
                    }
                    this.setMethod.invoke(modelObject, value);
                    if (modelObject instanceof InputElement) {
                        ((InputElement)modelObject).setSuppressEvents(false);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if ((errorMsg = checkResult == null ? "Internal software problem - please contact support" : (modelObject instanceof InputElement ? ((InputElement)modelObject).getErrorMessage() : "Value is invalid")).length() > 80) {
                String newErrorMsg = "";
                int i = 0;
                while (i < errorMsg.length()) {
                    newErrorMsg = i + 80 < errorMsg.length() ? String.valueOf(newErrorMsg) + errorMsg.substring(i, i + 80) + "\n" : String.valueOf(newErrorMsg) + errorMsg.substring(i);
                    i += 80;
                }
                errorMsg = newErrorMsg;
            }
            return new Status(4, "unknown plugin id", 42, errorMsg, null);
        }
        return Status.OK_STATUS;
    }

    public boolean isAdditionallySetInvalidValues() {
        return this.additionallySetInvalidValues;
    }

    public void setAdditionallySetInvalidValues(boolean additionallySetInvalidValues) {
        this.additionallySetInvalidValues = additionallySetInvalidValues;
    }
}

