/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.handlers;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPerspectiveToolItemHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Execute
    public void execute(MWindow window, EModelService modelService, EPartService partService) {
        this.logger.trace("execute");
        this.doExecute(window, modelService, partService);
    }

    public void doExecute(MWindow window, EModelService modelService, EPartService partService) {
        this.logger.trace("doExecute");
        MPerspective inputP = (MPerspective)modelService.find("de.tu_bs.ilr.esa.estec.neopop.gui.perspectives.input", (MUIElement)window);
        MPerspective outputP = (MPerspective)modelService.find("de.tu_bs.ilr.esa.estec.neopop.gui.perspectives.output", (MUIElement)window);
        MPerspective activeP = modelService.getActivePerspective(window);
        this.logger.debug("Active perspective: {}", (Object)activeP);
        MPerspective perspectiveToSwitchTo = activeP == inputP ? outputP : inputP;
        this.logger.debug("Switching to {}", (Object)perspectiveToSwitchTo.getElementId());
        partService.switchPerspective(perspectiveToSwitchTo);
        if (perspectiveToSwitchTo == outputP) {
            this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/output/refreshIfRequired", null);
        }
    }
}

