/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.PartType;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.NEOPOPModule;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsAutoSelectController
implements PropertyChangeListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    IEventBroker eventBroker;
    private volatile PartType selectedSettings;
    private NEOPOPModule neopopModule;

    @PostConstruct
    void postConstruct(Input input) {
        this.logger.trace("postConstruct(..)");
        this.neopopModule = input.getNeopopModule();
        this.neopopModule.addPropertyChangeListener("populationGenerationEnabled", (PropertyChangeListener)this);
        this.neopopModule.addPropertyChangeListener("populationAnalysisEnabled", (PropertyChangeListener)this);
        this.neopopModule.addPropertyChangeListener("observationSimulationEnabled", (PropertyChangeListener)this);
        this.neopopModule.addPropertyChangeListener("observationAnalysisEnabled", (PropertyChangeListener)this);
    }

    @Inject
    @Optional
    public void selectSettings(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/settings/select") PartType selectedSettings) {
        this.logger.trace("selectSettings(selectedSettings={})", (Object)selectedSettings);
        this.logger.debug("Saving settings selection {}", (Object)selectedSettings);
        this.selectedSettings = selectedSettings;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.logger.trace("propertyChange(evt={})", (Object)evt);
        if (!((Boolean)evt.getNewValue()).booleanValue()) {
            this.logger.debug("A NEOPOP module has been unselected => Determining settings auto-selection.");
            PartType autoSelection = this.determineAutoSelection();
            if (this.selectedSettings != autoSelection) {
                this.logger.debug("Auto-selection required.");
                this.logger.debug("Auto-selecting {}", (Object)autoSelection);
                this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/settings/select", (Object)autoSelection);
            } else {
                this.logger.debug("No auto-selection required.");
            }
        }
    }

    private PartType determineAutoSelection() {
        PartType previousSettingsSelection = null;
        PartType currentSettingsSelection = this.selectedSettings;
        while ((previousSettingsSelection = currentSettingsSelection) != (currentSettingsSelection = this.determineNextAutoSelection(previousSettingsSelection))) {
        }
        return currentSettingsSelection;
    }

    private PartType determineNextAutoSelection(PartType previousSettings) {
        if (previousSettings == null) {
            return null;
        }
        switch (previousSettings) {
            case POPULATION_SETTINGS_POPGEN: {
                if (this.neopopModule.getPopulationGenerationEnabled().booleanValue()) break;
                return PartType.BASIC_SETTINGS_POPGEN;
            }
            case FILTER_SETTINGS: 
            case HISTOGRAM_SETTINGS_2D_POPGEN: 
            case HISTOGRAM_SETTINGS_3D_POPGEN: 
            case SCATTER_PLOT_SETTINGS_POPGEN: {
                if (this.neopopModule.getPopulationAnalysisEnabled().booleanValue()) break;
                return PartType.BASIC_SETTINGS_POPGEN;
            }
            case POPULATION_SETTINGS_OBSSIM: 
            case NETWORK_SETTINGS: 
            case GROUND_BASED_LOCATION_SETTINGS: 
            case SPACE_BASED_LOCATIONS_SETTINGS: 
            case OPTICAL_SENSOR_SETTINGS: 
            case RADAR_SENSOR_SETTINGS: {
                if (this.neopopModule.getObservationSimulationEnabled().booleanValue()) break;
                return PartType.BASIC_SETTINGS_OBSSIM;
            }
            case HISTOGRAM_SETTINGS_2D_OBSSIM: 
            case HISTOGRAM_SETTINGS_3D_OBSSIM: 
            case SCATTER_PLOT_SETTINGS_OBSSIM: {
                if (this.neopopModule.getObservationAnalysisEnabled().booleanValue()) break;
                return PartType.BASIC_SETTINGS_OBSSIM;
            }
            case BASIC_SETTINGS_POPGEN: {
                if (this.neopopModule.getPopulationGenerationEnabled().booleanValue() || this.neopopModule.getPopulationAnalysisEnabled().booleanValue()) break;
                if (this.neopopModule.getObservationSimulationEnabled().booleanValue() || this.neopopModule.getObservationAnalysisEnabled().booleanValue()) {
                    return PartType.BASIC_SETTINGS_OBSSIM;
                }
                return null;
            }
            case BASIC_SETTINGS_OBSSIM: {
                if (this.neopopModule.getObservationSimulationEnabled().booleanValue() || this.neopopModule.getObservationAnalysisEnabled().booleanValue()) break;
                if (this.neopopModule.getPopulationGenerationEnabled().booleanValue() || this.neopopModule.getPopulationAnalysisEnabled().booleanValue()) {
                    return PartType.BASIC_SETTINGS_POPGEN;
                }
                return null;
            }
        }
        return previousSettings;
    }
}

