/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.SensorManifestationLocationAndSensorController;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.Location;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawGbModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawNetModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawOptModule;
import de.tu_bs.ilr.esa.estec.neopop.model.Sensor;
import de.tu_bs.ilr.esa.estec.neopop.model.SensorSystem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorSystemAddRemoveController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SensorManifestationLocationAndSensorController manifestationLocationAndTelescopeController;

    @Inject
    public SensorSystemAddRemoveController(SensorManifestationLocationAndSensorController manifestationLocationAndTelescopeController) {
        this.manifestationLocationAndTelescopeController = manifestationLocationAndTelescopeController;
    }

    public void add(ObsSimRawNetModule obsSimRawNetModule, ObsSimRawGbModule obsSimRawGbModule, ObsSimRawOptModule obsSimRawOptModule) {
        this.logger.trace("add(obsSimRawNetModule={})", (Object)obsSimRawNetModule);
        this.logger.info("Adding Sensor Network");
        SensorSystem newSystem = obsSimRawNetModule.addSensorNetwork();
        this.manifestationLocationAndTelescopeController.createBindings(newSystem);
        if (!obsSimRawGbModule.getGroundLocations().isEmpty()) {
            Location defaultLocation = (Location)obsSimRawGbModule.getGroundLocations().get(0);
            newSystem.getReceiver().setLocation(defaultLocation);
            newSystem.getTransmitter().setLocation(defaultLocation);
        }
        if (!obsSimRawOptModule.getOpticalTelescopes().isEmpty()) {
            Sensor defaultSensor = (Sensor)obsSimRawOptModule.getOpticalTelescopes().get(0);
            newSystem.getReceiver().setTelescope(defaultSensor);
            newSystem.getTransmitter().setTelescope(defaultSensor);
        }
    }

    public void remove(SensorSystem network) {
        this.logger.trace("remove(network={})", (Object)network);
        this.logger.info("Removing Sensor Network {}", (Object)network);
        this.manifestationLocationAndTelescopeController.removeBindings(network);
        network.getParent().removeSensorNetwork(network);
    }

    @Inject
    @Optional
    public void processSensorNetworkAddEvent(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/sensorNetwork/added") Event event, Input model) {
        this.logger.trace("processSensorNetworkAddEvent(...)");
        this.add(model.getObsSimRawNetModule(), model.getObsSimRawGbModule(), model.getObsSimRawOptModule());
    }

    @Inject
    @Optional
    public void processSensorNetworkRemoveEvent(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/sensorNetwork/removed") SensorSystem network) {
        this.logger.trace("processSensorNetworkRemoveEvent(network={})", (Object)network);
        this.remove(network);
    }
}

