/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.IModelConnector;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetInputController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean firstReset = true;

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    public void resetInput(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/input/reset") boolean resetToPreviouslySavedInput, IModelConnector modelConnector, Input input, Model model) {
        this.logger.trace("resetInput");
        this.logger.info("Resetting all NEOPOP input data to {} input data", (Object)(resetToPreviouslySavedInput ? "previously saved" : "default"));
        Path currentProjDirPath = model.getWorkspace().getProject().getPath();
        Path defaultProjDirPath = FileSystems.getDefault().getPath(System.getProperty("user.dir"), "..", "default");
        String tmpNeopopCfgFilePath = null;
        String tmpPopGenCfgFilePath = null;
        String tmpObsSimCfgFilePath = null;
        if (!this.firstReset) {
            input.loadTempValues();
        }
        if (!resetToPreviouslySavedInput) {
            Path defaultNeopopCfgFilePath = defaultProjDirPath.resolve("neopop.cfg");
            tmpNeopopCfgFilePath = input.getNeopopModule().getNeopopCfgFilePath();
            input.getNeopopModule().setNeopopCfgFilePath(defaultNeopopCfgFilePath.toString());
        }
        modelConnector.read_input_file("NEOPOP_READ_CFG");
        if (!resetToPreviouslySavedInput) {
            input.getNeopopModule().setNeopopCfgFilePath(tmpNeopopCfgFilePath);
        }
        String popGenCfgFilePathInNeopopModule = input.getNeopopModule().getPopulationGeneratorCfgFilePath();
        Path absolutePopGenCfgFilePath = null;
        if (resetToPreviouslySavedInput) {
            absolutePopGenCfgFilePath = currentProjDirPath.resolve(popGenCfgFilePathInNeopopModule);
        } else {
            absolutePopGenCfgFilePath = defaultProjDirPath.resolve(popGenCfgFilePathInNeopopModule);
            tmpPopGenCfgFilePath = input.getPopGenInpCfgModule().getCfgFilePath();
        }
        input.getPopGenInpCfgModule().setCfgFilePath(absolutePopGenCfgFilePath.toString());
        modelConnector.read_input_file("POPGEN_READ_CFG");
        input.getPopGenInpCfgModule().setDataDir(this.determineDataFolderPath(currentProjDirPath, "01-POPGEN"));
        if (!resetToPreviouslySavedInput) {
            input.getPopGenInpCfgModule().setCfgFilePath(tmpPopGenCfgFilePath);
        }
        if (resetToPreviouslySavedInput) {
            input.getPopGenInpCfgModule().setProjectFolder(currentProjDirPath.toString());
        } else {
            input.getPopGenInpCfgModule().setProjectFolder(defaultProjDirPath.toString());
        }
        modelConnector.read_input_file("POPGEN_READ_PLT");
        modelConnector.read_input_file("POPGEN_READ_INP");
        modelConnector.read_input_file("POPGEN_READ_FIL");
        if (!resetToPreviouslySavedInput) {
            input.getPopGenInpCfgModule().setProjectFolder(currentProjDirPath.toString());
        }
        String obsSimCfgFilePathInNeopopModule = input.getNeopopModule().getObservationSimulatorCfgFilePath();
        Path absoluteObsSimCfgFilePath = null;
        if (resetToPreviouslySavedInput) {
            absoluteObsSimCfgFilePath = currentProjDirPath.resolve(obsSimCfgFilePathInNeopopModule);
        } else {
            absoluteObsSimCfgFilePath = defaultProjDirPath.resolve(obsSimCfgFilePathInNeopopModule);
            tmpObsSimCfgFilePath = input.getObsSimRawCfgModule().getCfgFilePath();
        }
        input.getObsSimRawCfgModule().setCfgFilePath(absoluteObsSimCfgFilePath.toString());
        modelConnector.read_input_file("OBSSIM_READ_CFG");
        input.getObsSimRawCfgModule().setDataDir(this.determineDataFolderPath(currentProjDirPath, "02-OBSSIM"));
        if (!resetToPreviouslySavedInput) {
            input.getObsSimRawCfgModule().setCfgFilePath(tmpObsSimCfgFilePath);
        }
        if (resetToPreviouslySavedInput) {
            input.getObsSimRawCfgModule().setProjectDirPath(currentProjDirPath.toString());
        } else {
            input.getObsSimRawCfgModule().setProjectDirPath(defaultProjDirPath.toString());
        }
        modelConnector.read_input_file("OBSSIM_READ_INP");
        modelConnector.read_input_file("OBSSIM_READ_SRC");
        modelConnector.read_input_file("OBSSIM_READ_NET");
        modelConnector.read_input_file("OBSSIM_READ_OCL");
        modelConnector.read_input_file("OBSSIM_READ_G_B");
        modelConnector.read_input_file("OBSSIM_READ_S_B");
        modelConnector.read_input_file("OBSSIM_READ_OPT");
        modelConnector.read_input_file("OBSSIM_READ_RAD");
        modelConnector.read_input_file("OBSSIM_READ_PLT");
        if (!resetToPreviouslySavedInput) {
            input.getObsSimRawCfgModule().setProjectDirPath(currentProjDirPath.toString());
        }
        input.synchIndexedPropertiesWithFortran();
        if (this.firstReset) {
            this.firstReset = false;
        } else {
            input.checkChangeAgainstTempValuesAndCheckDependencies();
        }
    }

    private String determineDataFolderPath(Path projDirPath, String neopopPartFolder) {
        Path projectDataFolder = projDirPath.resolve(neopopPartFolder).resolve("data");
        if (projectDataFolder.toFile().exists()) {
            return projectDataFolder.toString();
        }
        return FileSystems.getDefault().getPath(System.getProperty("user.dir"), "..", "default", neopopPartFolder, "data").toString();
    }
}

