/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.PartType;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPart part;
    private String partID;
    private boolean finalized = false;

    @PostConstruct
    public void createPart(IView viewService, MPart mpart, IEclipseContext context) {
        this.logger.trace("createPart");
        this.partID = mpart.getElementId();
        PartType partType = PartType.getByID((String)this.partID);
        Class cl = viewService.getPartImplementationClass(partType);
        this.part = (IPart)ContextInjectionFactory.make((Class)cl, (IEclipseContext)context);
        this.part.doAdditionalStuff();
        this.part.bindGUIElements();
    }

    @Inject
    @Optional
    public void processActivatePartEvent(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (!this.finalized) {
            this.part.finalizeCreation();
            this.finalized = true;
        }
    }

    @Focus
    public void focus() {
        this.logger.trace("focus");
        this.part.focus();
    }

    @PreDestroy
    public void preDestroy() {
        this.logger.trace("preDestroy");
    }

    public IPart getPart() {
        return this.part;
    }
}

