/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.Activator;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PrefUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PreferenceEntry;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PresenterUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.BrowseAndEditController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.DialogController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.ExportController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.ImportController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.InputCheckController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.ModelPrintController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.OpenPDFController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.OutputController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.PreferencesController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.ProjectController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.ProjectNameController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.QuitController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.RemoveProjectController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.ReplotController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.ResetInputController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.SensorManifestationLocationAndSensorController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.SensorSystemAddRemoveController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.SettingsAutoSelectController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.TestController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.UndoGnuplotFileController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.WindowLayoutResetController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.WorkspaceController;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.handlers.SettingsButtonHandler;
import de.tu_bs.ilr.esa.estec.neopop.gui.util.GUIVersion;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import de.tu_bs.ilr.esa.estec.neopop.model.Output;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.IModelConnector;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.LoggedConnector;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessRemovals;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleController {
    private boolean somePartHasBeenActivated = false;
    private Model model;
    private PrefUtil prefUtil;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Inject
    void muh(IEclipseContext context) {
    }

    @PostConstruct
    public void postConstruct(IEclipseContext context, IView view, IEventBroker eventBroker) {
        this.logger.trace("postConstruct");
        context.set(GUIVersion.class, (Object)Activator.getVersion());
        this.logger.info("This is NEOPOP GUI Version {}", (Object)Activator.getVersion());
        this.logger.debug("Current dir: {}", (Object)System.getProperty("user.dir"));
        this.logger.debug("User home dir: {}", (Object)System.getProperty("user.home"));
        this.logger.debug("Eclipse user area: {}", (Object)Platform.getUserLocation().getURL());
        this.logger.debug("Eclipse conf area: {}", (Object)Platform.getConfigurationLocation().getURL());
        this.logger.debug("Eclipse instance area (should be null upon first start/if user asked another workspace to be opened): {}", (Object)Platform.getInstanceLocation().getURL());
        this.logger.debug("Processor type: {}", (Object)System.getProperty("org.osgi.framework.processor"));
        this.logger.debug("Creating LoggedConnector");
        LoggedConnector loggedConnector = new LoggedConnector((IModelConnector)context.get(IModelConnector.class));
        context.set(IModelConnector.class, (Object)loggedConnector);
        Path confDir = FileSystems.getDefault().getPath(System.getProperty("user.home"), "neopop-gui", "conf");
        this.logger.debug("Initiating FORTRAN connection");
        try {
            loggedConnector.initConnection();
        }
        catch (UnsatisfiedLinkError e) {
            this.logger.error("Could not initiate FORTRAN connection: {}", (Object)e.getMessage(), (Object)e);
            view.openErrorDialog("Error launching NEOPOP GUI", "ESA NEOPOP GUI could not be launched, because the FORTRAN connection library could not be loaded.\n\nIf the error message at the bottom of this dialog tells you something about a 32-bit library that can't be loaded on a 64-bit system, just try restarting the GUI. If this does not work, please consult Software User Manual.\nError message: " + e.getMessage());
            this.logger.debug("Deleting GUI installation timestamp");
            try {
                Files.deleteIfExists(confDir.resolve("gui_install_timestamp"));
            }
            catch (IOException iOException) {
                this.logger.error("Could not delete GUI installation timestamp: {}", (Object)e.getMessage(), (Object)e);
            }
            throw e;
        }
        loggedConnector.set_log_files(confDir.resolve("neopop.log").toString(), confDir.resolve("neopop.err").toString());
        this.createObjectAndSetItIntoContext(InputCheckController.class, context);
        this.prefUtil = new PrefUtil();
        context.set(PrefUtil.class, (Object)this.prefUtil);
        this.createObjectAndSetItIntoContext(PresenterUtil.class, context);
        this.model = new Model((IModelConnector)loggedConnector);
        context.set(Model.class, (Object)this.model);
        Input input = this.model.getWorkspace().getProject().getInput();
        context.set(Input.class, (Object)input);
        Output output = this.model.getWorkspace().getProject().getOutput();
        context.set(Output.class, (Object)output);
        this.createObjectAndSetItIntoContext(PreferencesController.class, context);
        eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/preferences/load", null);
        this.createObjectAndSetItIntoContext(QuitController.class, context);
        this.createObjectAndSetItIntoContext(WorkspaceController.class, context);
        this.createObjectAndSetItIntoContext(ProjectController.class, context);
        this.createObjectAndSetItIntoContext(SettingsButtonHandler.class, context);
        this.createObjectAndSetItIntoContext(TestController.class, context);
        this.createObjectAndSetItIntoContext(ModelPrintController.class, context);
        this.createObjectAndSetItIntoContext(SensorManifestationLocationAndSensorController.class, context);
        this.createObjectAndSetItIntoContext(SensorSystemAddRemoveController.class, context);
        this.createObjectAndSetItIntoContext(OutputController.class, context);
        this.createObjectAndSetItIntoContext(DialogController.class, context);
        this.createObjectAndSetItIntoContext(ImportController.class, context);
        this.createObjectAndSetItIntoContext(ExportController.class, context);
        this.createObjectAndSetItIntoContext(RemoveProjectController.class, context);
        this.createObjectAndSetItIntoContext(ResetInputController.class, context);
        this.createObjectAndSetItIntoContext(OpenPDFController.class, context);
        this.createObjectAndSetItIntoContext(ProjectNameController.class, context);
        this.createObjectAndSetItIntoContext(ReplotController.class, context);
        this.createObjectAndSetItIntoContext(UndoGnuplotFileController.class, context);
        this.createObjectAndSetItIntoContext(BrowseAndEditController.class, context);
        this.createObjectAndSetItIntoContext(WindowLayoutResetController.class, context);
        this.createObjectAndSetItIntoContext(SettingsAutoSelectController.class, context);
        eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/workspace/openCurrent", null);
        if (this.model.getWorkspace().getPath() != null) {
            eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/openCurrent", null);
        }
    }

    private <T> T createObjectAndSetItIntoContext(Class<T> objectClass, IEclipseContext context) {
        Object object = ContextInjectionFactory.make(objectClass, (IEclipseContext)context);
        context.set(objectClass, object);
        return (T)object;
    }

    @PostContextCreate
    void postContextCreate(IEventBroker eventBroker) {
        this.logger.trace("postContextCreate");
    }

    @ProcessAdditions
    public void processAdditions(EModelService modelService, EPartService partService, MApplication app, IEventBroker eventBroker) {
        this.logger.trace("processAdditions");
        MPartSashContainer verticalPartSashContainer = (MPartSashContainer)modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partsashcontainers.output.vertical", MPartSashContainer.class, null).get(0);
        MPartStack primaryOutputObjectStack = (MPartStack)modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partstacks.output.object.primary", MPartStack.class, null).get(0);
        MPartStack secondaryOutputObjectStack = (MPartStack)modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partstacks.output.object.secondary", MPartStack.class, null).get(0);
        if (!verticalPartSashContainer.isVisible()) {
            verticalPartSashContainer.setVisible(true);
        }
        verticalPartSashContainer.getTags().add("NoAutoCollapse");
        primaryOutputObjectStack.getTags().add("NoAutoCollapse");
        secondaryOutputObjectStack.getTags().add("NoAutoCollapse");
        eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/showProjectName", null);
    }

    @ProcessRemovals
    public void processRemovals() {
        this.logger.trace("processRemovals");
    }

    @Inject
    @Optional
    public void processActivatePartEvent(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event, Input input, SensorManifestationLocationAndSensorController sensorManifestationLocationHandler, IEventBroker eventBroker, Model model) {
        this.logger.trace("processActivatePartEvent");
        if (model.getWorkspace().getPath() == null) {
            eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/quit", null);
        }
        if (!this.somePartHasBeenActivated) {
            this.somePartHasBeenActivated = true;
            this.logger.debug("Processing NEOPOP model now");
            sensorManifestationLocationHandler.reset(input.getObsSimRawNetModule(), input.getObsSimRawGbModule(), input.getObsSimRawSbModule(), input.getObsSimRawOptModule(), input.getObsSimRawRadModule());
            eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/output/refreshIfRequired", null);
        } else {
            this.logger.trace("Skipping");
        }
    }

    @Inject
    @Optional
    public void test(@EventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event o) {
        Object mui = o.getProperty("ChangedElement");
        if (mui instanceof MApplication) {
            MWindow win = (MWindow)o.getProperty("NewValue");
            System.err.println(win);
        }
    }

    @PreDestroy
    public void preDestroy(IEventBroker eventBroker, IView view) {
        this.logger.trace("preDestroy");
        this.logger.info("Closing");
        this.savePreferences();
        view.dispose();
    }

    private void savePreferences() {
        this.logger.info("savePreferences");
        this.prefUtil.set(PreferenceEntry.NEOPOP_EXE_FILE_PATH, this.model.getNeopopExeFilePath());
        this.prefUtil.set(PreferenceEntry.GNUPLOT_EXE_FILE_PATH, this.model.getGnuplotExeFilePath());
        this.prefUtil.set(PreferenceEntry.PDF_VIEWER_EXE_FILE_PATH, this.model.getPdfViewerExeFilePath());
        this.prefUtil.set(PreferenceEntry.WORKSPACE_PATH, this.model.getWorkspace().getPath());
        this.prefUtil.set(PreferenceEntry.TEXT_EDITOR_FILE_PATH, this.model.getTextEditorExeFilePath());
        this.prefUtil.set(PreferenceEntry.PROJECT_PATH, this.model.getWorkspace().getProject().getPath() == null ? null : this.model.getWorkspace().getProject().getPath().toString());
        this.prefUtil.set(PreferenceEntry.USE_GENERATED_POPULATION_AS_OBSERVATION_SIMULATOR_INPUT, String.valueOf(this.model.getWorkspace().getProject().getUseGeneratedPopulationAsObservationSimulatorInput()));
    }

    @Inject
    @Optional
    public void processTestUIEvent(@UIEventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/test") Event event) {
        this.logger.trace("processTestUIEvent");
    }
}

