/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusPrintController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final boolean ONLY_NEOPOP_GUI_EVENTS = false;

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    public void guiEventPresenter(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/*") Event event) {
        this.logger.trace("guiEventPresenter");
    }

    @Inject
    @Optional
    public void guiEventPresenterAndView(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/*") Event event) {
        this.logger.trace("guiEventPresenterAndView");
    }

    @Inject
    @Optional
    public void guiUIEventPresenter(@UIEventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/*") Event event) {
        this.logger.trace("guiUIEventPresenter - uiuiui!");
    }

    @Inject
    @Optional
    public void guiUIEventPresenterAndView(@UIEventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/*") Event event) {
        this.logger.trace("guiUIEventPresenterAndView - uiuiui!");
    }

    @Inject
    @Optional
    public void someUIEvent(@UIEventTopic(value="*") Event event) {
        this.logger.trace("someUIEvent");
        this.logEvent(event, "Some UI");
    }

    @Inject
    @Optional
    public void someEvent(@EventTopic(value="*") Event event) {
        this.logger.trace("someEvent");
        this.logEvent(event, "Some");
    }

    private void logEvent(Event event, String type) {
        this.logger.debug("{} event: {}", (Object)(event == null ? "null" : event.getTopic()));
        if (event != null) {
            String[] stringArray = event.getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                this.logger.debug("property: {} = {}", (Object)property, event.getProperty(property));
                ++n2;
            }
        }
    }
}

