/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.util.UberUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.model.BasePathType;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseAndEditController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IView view;

    @PostConstruct
    void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    public void browseFile(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/browseFile") Event event, Model model, IView view) {
        this.logger.trace("browseFile");
        ModelElement modelElement = (ModelElement)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/modelElement");
        String property = (String)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/property");
        Path projDirPath = model.getWorkspace().getProject().getPath();
        Path basePath = this.getBasePath(modelElement, property, projDirPath);
        Path selectedFilePath = view.openFileDialog(null, basePath);
        this.savePath(modelElement, property, selectedFilePath, basePath, projDirPath);
    }

    @Inject
    @Optional
    public void browseDir(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/browseDir") Event event, Model model, IView view) {
        this.logger.trace("browseDir");
        ModelElement modelElement = (ModelElement)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/modelElement");
        String property = (String)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/property");
        Path projDirPath = model.getWorkspace().getProject().getPath();
        Path basePath = this.getBasePath(modelElement, property, projDirPath);
        Path selectedDirPath = view.openDirDialog(null, basePath);
        this.savePath(modelElement, property, selectedDirPath, basePath, projDirPath);
    }

    private void savePath(ModelElement modelElement, String property, Path selectedFilePath, Path basePath, Path projDirPath) {
        if (selectedFilePath == null) {
            return;
        }
        selectedFilePath = selectedFilePath.normalize();
        projDirPath = projDirPath.normalize();
        BasePathType basePathType = modelElement.getBasePathType(property);
        if (basePathType != BasePathType.GUI_EXEC_DIR) {
            basePath = basePath.normalize();
            FileSystems.getDefault().getPath(System.getProperty("user.dir"), "..", "default").normalize();
            if (selectedFilePath.startsWith(projDirPath)) {
                selectedFilePath = basePath.relativize(selectedFilePath);
            }
        }
        UberUtil.set((ModelElement)modelElement, (String)property, (String)selectedFilePath.toString());
    }

    @Inject
    @Optional
    public void editFile(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/editFile") Event event, Model model) {
        this.logger.trace("editFile");
        ModelElement modelElement = (ModelElement)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/modelElement");
        String property = (String)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/property");
        Path absoluteFilePath = this.getAbsoluteFilePath(modelElement, property, model.getWorkspace().getProject().getPath());
        String textEditorExeFilePath = model.getTextEditorExeFilePath();
        if (textEditorExeFilePath == null || textEditorExeFilePath.equals("")) {
            this.logger.error("PDF viewerText editor exe file path not set");
            this.view.openErrorDialog("Text editor not set", "Text editor has not been set.\nPlease click on the settings button in the toolbar to do so.");
            return;
        }
        String command = String.valueOf(textEditorExeFilePath) + " " + absoluteFilePath;
        this.logger.info("Editing file \"{}\"", (Object)absoluteFilePath);
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            this.logger.error("Could not execute \"{}\": {}", new Object[]{command, e, e});
        }
    }

    private Path getAbsoluteFilePath(ModelElement modelElement, String property, Path projDirPath) {
        String filePathString = UberUtil.get((ModelElement)modelElement, (String)property);
        Path filePath = FileSystems.getDefault().getPath(filePathString, new String[0]);
        if (!filePath.isAbsolute()) {
            Path basePath = this.getBasePath(modelElement, property, projDirPath);
            filePath = basePath.resolve(filePath);
        }
        return filePath;
    }

    private Path getBasePath(ModelElement modelElement, String property, Path projDirPath) {
        BasePathType basePathType = modelElement.getBasePathType(property);
        Path defaultProjDirPath = FileSystems.getDefault().getPath(System.getProperty("user.dir"), "..", "default");
        switch (basePathType) {
            case TOOL_EXEC_DIR: 
            case POPGEN_PROJECT_DIR: 
            case OBSSIM_PROJECT_DIR: {
                return projDirPath;
            }
            case POPGEN_INPUT_DIR: {
                return projDirPath.resolve("01-POPGEN").resolve("input");
            }
            case OBSSIM_INPUT_DIR: {
                return projDirPath.resolve("02-OBSSIM").resolve("input");
            }
            case POPGEN_DATA_DIR: {
                return defaultProjDirPath.resolve("01-POPGEN").resolve("data");
            }
            case OBSSIM_DATA_DIR: {
                return defaultProjDirPath.resolve("02-OBSSIM").resolve("data");
            }
            case GUI_EXEC_DIR: {
                return FileSystems.getDefault().getPath(System.getProperty("user.dir"), new String[0]);
            }
        }
        this.logger.error("Could not map base path type to actual base path");
        return null;
    }
}

