/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowLayoutBackupProcessor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Execute
    void execute(MApplication app, EModelService modelService) {
        this.logger.trace("execute(...)");
        this.logger.debug("Checking if perspective backups have been made in a previous run of NEOPOP GUI");
        boolean perspectiveBackupsExist = false;
        for (MUIElement element : app.getSnippets()) {
            if (!(element instanceof MPerspective)) continue;
            perspectiveBackupsExist = true;
        }
        if (perspectiveBackupsExist) {
            this.logger.debug("Perspective backup found. Nothing to do for me here");
        } else {
            this.logger.info("No window layout backup found. Backing up now.");
            this.logger.debug("Backing up perspectives");
            for (MPerspective perspective : modelService.findElements((MUIElement)app, null, MPerspective.class, null)) {
                this.logger.debug("Backing up {}", (Object)perspective);
                MPerspective cfr_ignored_0 = (MPerspective)modelService.cloneElement((MUIElement)perspective, (MSnippetContainer)app);
            }
        }
    }
}

