reset
set term png
set key vertical outside right center
set key textcolor rgbcolor "grey70"
unset logscale x
unset logscale y
set xrange [      -5.400:       5.400]
set yrange [      -5.400:       5.400]
set title "Test run of the\nPopulation Generator\nSolar System Side View" offset 0,2
# prepare the solar system
set parametric
set trange [0:2*pi]
# Sun
rs = 0.04
fxs(t) = rs*cos(t)
fys(t) = rs*sin(t)
# 
# X-axis markers for Earth and Mars
f_markers_y(t) = -5.3+(t*0.15)/(2*pi)
r_Earth = 1.000
f_Earth_marker_left_x(t) = r_Earth
f_Earth_marker_right_x(t) = -r_Earth
r_Mars = 1.324
f_Mars_marker_left_x(t) = r_Mars
f_Mars_marker_right_x(t) = -r_Mars
# 
# Jupiter
rj = 5.201
fxj(t) = rj*cos(t)
fyj(t) = rj*sin(t)
# common z axis = 0
fz(t) = 0
set view 0,0
unset border
set size square
set xlabel "[AU]"
set xlabel textcolor rgbcolor "grey30"
set xlabel offset 25,1.5
set ylabel "[AU]"
set ylabel offset 0.5,9.75
set ylabel textcolor rgbcolor "grey30"
set ylabel norotate
set border linecolor rgbcolor "grey30"
set title textcolor rgbcolor "grey70"
set obj 1 rectangle behind from screen 0,0 to screen 1,1
set obj 1 fillstyle solid 1.0 fillcolor rgbcolor "black"
set style fill pattern 2
set output "neopop_S01_SLS_MC01.png"
plot fxs(t),fz(t) lc rgb "yellow" lw 2 t "Sun" w filledcurves below, \
f_Earth_marker_left_x(t),f_markers_y(t) lt 3 lc rgb "#7070DD" lw 1 t "Earth", \
f_Earth_marker_right_x(t),f_markers_y(t) lt 3 lc rgb "#7070DD" lw 1 notitle, \
f_Mars_marker_left_x(t),f_markers_y(t) lt 4 lc rgb "#DD9090" lw 1 t "Mars", \
f_Mars_marker_right_x(t),f_markers_y(t) lt 4 lc rgb "#DD9090" lw 1 notitle, \
fxj(t),fz(t) lc rgb "#DDB070" lw 1 t "Jupiter", \
"neopop_S01_SL_MC01_d.spc" u 4:($3 <= 4 ? $6 : 1/0) lc rgb "green" lw 1 w dots t "Crossings", \
"neopop_S01_SL_MC01_d.spc" u 4:($3 == 4 ? $6 : 1/0) lc rgb "red" lw 1 w dots t "Detections"
