/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.util;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedUpdateValueStrategy
extends UpdateValueStrategy {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected IValidator beforeConvertValidator = null;
    protected IStatus beforeConvertValidationStatus = Status.OK_STATUS;

    public ExtendedUpdateValueStrategy() {
    }

    public ExtendedUpdateValueStrategy(boolean provideDefaults) {
        super(provideDefaults, UpdateValueStrategy.POLICY_UPDATE);
    }

    public ExtendedUpdateValueStrategy(int updatePolicy) {
        super(updatePolicy);
    }

    public ExtendedUpdateValueStrategy(boolean provideDefaults, int updatePolicy) {
        super(provideDefaults, updatePolicy);
    }

    public void setBeforeConvertValidator(IValidator beforeConvertValidator) {
        this.beforeConvertValidator = beforeConvertValidator;
    }

    public IValidator getBeforeConvertValidator() {
        return this.beforeConvertValidator;
    }

    public Object convert(Object value) {
        this.logger.trace("convert(value={})", value);
        if (this.beforeConvertValidator != null) {
            this.logger.debug("Validating {} before convert", value);
            this.beforeConvertValidationStatus = this.beforeConvertValidator.validate(value);
            if (!this.beforeConvertValidationStatus.isOK()) {
                this.logger.error("Before convert validation of value {} failed: {}", new Object[]{value, this.beforeConvertValidationStatus.getMessage(), this.beforeConvertValidationStatus.getException()});
            }
            this.logger.debug("Before convert validation result: ", value);
        }
        Object result = super.convert(value);
        this.logger.trace("result={}", result);
        return result;
    }

    public IStatus validateAfterConvert(Object value) {
        this.logger.trace("validateAfterConvert(value={})", value);
        IStatus result = super.validateAfterConvert(value);
        this.logger.trace("result={}", (Object)result);
        return result;
    }

    public IStatus validateAfterGet(Object value) {
        this.logger.trace("validateAfterGet(value={})", value);
        IStatus result = super.validateAfterGet(value);
        this.logger.trace("result={}", (Object)result);
        return result;
    }

    public IStatus validateBeforeSet(Object value) {
        this.logger.trace("validateBeforeSet(value={})", value);
        IStatus result = super.validateBeforeSet(value);
        this.logger.trace("result={}", (Object)result);
        return result;
    }

    protected IStatus doSet(IObservableValue observableValue, Object value) {
        this.logger.trace("doSet(observableValue={}, value={})", (Object)observableValue, value);
        IStatus setStatus = super.doSet(observableValue, value);
        if (!this.beforeConvertValidationStatus.isOK()) {
            this.logger.error("Could not set value {} for observable value {}, since before convert validation failed (see above for details)", value, (Object)observableValue);
            this.logger.trace("result={}", (Object)this.beforeConvertValidationStatus);
            return this.beforeConvertValidationStatus;
        }
        if (!setStatus.isOK()) {
            this.logger.error("Could not set value {} for observable value {}", new Object[]{value, observableValue, setStatus.getException()});
            Status result = new Status(4, "de.tu_bs.ilr.esa.estec.neopop.gui.util", "Internal software problem - please contact support", setStatus.getException());
            this.logger.trace("result={}", (Object)result);
            return result;
        }
        this.logger.trace("result={}", (Object)setStatus);
        return setStatus;
    }
}

