/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Enabler;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.HeteroList;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.IAggregationEquation;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Util;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElementValue;
import de.tu_bs.ilr.esa.estec.neopop.model.NEOPOPModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawCfgModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawRadModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawSrcModule;
import de.tu_bs.ilr.esa.estec.neopop.model.RadarSensor;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadarSensorsPart
implements IPart {
    public static final String EXPLAINATION_OF_LOSSES = "Losses are expressed as the denominator in a fraction, with \"1\" meaning that no loss is introduced, all values between 0 and 1 meaning a gain and all values larger than 1 meaning a loss.";
    private ObsSimRawRadModule obsSimRawRadModule;
    private ObsSimRawCfgModule obsSimRawCfgModule;
    private WritableValue selection = new WritableValue();
    private WritableValue selectionRAError = new WritableValue();
    private WritableValue selectionDeclError = new WritableValue();
    private WritableValue selectionRangeError = new WritableValue();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TableViewer telescopesTableViewer;
    private Group grpSelection;
    private Text txtName;
    private Spinner spnFieldOfView;
    private Button addButton;
    private Button removeButton;
    private Text inputFileText;
    private Button inputFileBrowseButton;
    private Button inputFileEditButton;
    private Composite cmpNote;
    private Label lblNoteCaption;
    private Label lblNote;
    private Label sepGeneral;
    private Label lblGeneral;
    private Label label_2;
    private Label lblTransmittedPower;
    private Label lblMinReceivedPower;
    private Label lblAntennaDishDiameter;
    private Label lblAntennaEfficiencyFactor;
    private Label lblWaveLength;
    private Label lblLossDueToDecay;
    private Label lblLossDueToFluctuation;
    private Label lblLossDueToAtmosphere;
    private Spinner spnTransmittedPower;
    private Spinner spnMinReceivedPower;
    private Spinner spnAntennaDishDiameter;
    private Spinner spnAntennaEfficiencyFactor;
    private Spinner spnWaveLength;
    private Spinner spnLossDueToDecay;
    private Spinner spnLossDueToFluctuation;
    private Spinner spnLossDueToAtmosphere;
    private Label lblTransmittedPowerUnit;
    private Label lblMinReceivedPowerUnit;
    private Label lblAntennaDishDiameterUnit;
    private Label lblAntennaEfficiencyFactorUnit;
    private Label lblWaveLengthUnit;
    private Label lblLossDueToDecayUnit;
    private Label lblLossDueToFluctuationUnit;
    private Label lblLossDueToAtmosphereUnit;
    private Label label;
    private Label label_1;
    private Label lblErrors;
    private Label lblRa;
    private Label lblDecl;
    private Label lblRange;
    private Composite composite;
    private Spinner raDriftSpinner;
    private Spinner raBiasSpinner;
    private Spinner raNoiseSpinner;
    private Composite composite_1;
    private Composite composite_2;
    private Spinner declBiasSpinner;
    private Spinner declDriftSpinner;
    private Spinner declNoiseSpinner;
    private Composite composite_3;
    private Spinner rangeBiasSpinner;
    private Spinner rangeDriftSpinner;
    private Spinner rangeNoiseSpinner;
    private Label biasLabel;
    private Label driftLabel;
    private Label noiseLabel;
    private Label rangeUnitLabel;
    private Label declUnitLabel;
    private Label raUnitLabel;
    private Label label_3;
    private Group telescopesGroup;
    private Composite addRemoveComposite;
    private ObsSimRawSrcModule obsSimRawSrcModule;
    private NEOPOPModule neopopModule;
    private Composite compInScrolled;

    @Inject
    protected void setAttributesFromContext(Input model) {
        this.logger.trace("setAttributesFromContext");
        this.obsSimRawCfgModule = model.getObsSimRawCfgModule();
        this.obsSimRawRadModule = model.getObsSimRawRadModule();
        this.obsSimRawSrcModule = model.getObsSimRawSrcModule();
        this.neopopModule = model.getNeopopModule();
    }

    @PostConstruct
    public void createGUIElements(Composite cmpParent) {
        this.logger.debug("createGUIElements");
        this.logger.debug("Creating GUI elements");
        cmpParent.setLayout((Layout)new GridLayout(2, false));
        this.telescopesGroup = new Group(cmpParent, 0);
        this.telescopesGroup.setText("Defined Radar Sensors");
        GridLayout gl_telescopesGroup = new GridLayout(1, false);
        this.telescopesGroup.setLayout((Layout)gl_telescopesGroup);
        this.telescopesGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.telescopesTableViewer = new TableViewer((Composite)this.telescopesGroup, 67584);
        Table telescopesTable = this.telescopesTableViewer.getTable();
        telescopesTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.addRemoveComposite = new Composite((Composite)this.telescopesGroup, 0);
        this.addRemoveComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        RowLayout rl_addRemoveComposite = new RowLayout(256);
        this.addRemoveComposite.setLayout((Layout)rl_addRemoveComposite);
        this.addButton = new Button(this.addRemoveComposite, 0);
        this.addButton.setLayoutData((Object)new RowData(100, -1));
        this.addButton.setText("Add");
        this.removeButton = new Button(this.addRemoveComposite, 0);
        this.removeButton.setLayoutData((Object)new RowData(100, -1));
        this.removeButton.setText("Remove");
        this.grpSelection = new Group(cmpParent, 0);
        this.grpSelection.setText("Attributes of Selected Radar Sensor");
        this.grpSelection.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.grpSelection.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.grpSelection, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.compInScrolled = new Composite((Composite)scrolledComposite, 0);
        GridLayout gl_compInScrolled = new GridLayout(3, false);
        gl_compInScrolled.marginHeight = 0;
        gl_compInScrolled.verticalSpacing = 0;
        gl_compInScrolled.horizontalSpacing = 8;
        this.compInScrolled.setLayout((Layout)gl_compInScrolled);
        this.sepGeneral = new Label(this.compInScrolled, 258);
        GridData gd_sepGeneral = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_sepGeneral.heightHint = 30;
        this.sepGeneral.setLayoutData((Object)gd_sepGeneral);
        this.lblGeneral = new Label(this.compInScrolled, 0);
        this.lblGeneral.setText("General");
        new Label(this.compInScrolled, 0);
        new Label(this.compInScrolled, 0);
        this.label_2 = new Label(this.compInScrolled, 256);
        GridData gd_label_2 = new GridData(16384, 0x1000000, false, false, 3, 1);
        gd_label_2.heightHint = 15;
        this.label_2.setLayoutData((Object)gd_label_2);
        Label lblName = new Label(this.compInScrolled, 0);
        GridData gd_lblName = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblName.horizontalIndent = 20;
        lblName.setLayoutData((Object)gd_lblName);
        lblName.setText("Designator:");
        this.txtName = new Text(this.compInScrolled, 2048);
        this.txtName.setText("<designator>");
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.label_3 = new Label(this.compInScrolled, 0);
        this.label_3.setText("[-]");
        Label lblFieldOfView = new Label(this.compInScrolled, 0);
        GridData gd_lblFieldOfView = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblFieldOfView.horizontalIndent = 20;
        lblFieldOfView.setLayoutData((Object)gd_lblFieldOfView);
        lblFieldOfView.setText("Field of View:");
        this.spnFieldOfView = new Spinner(this.compInScrolled, 2048);
        this.spnFieldOfView.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnFieldOfView.setPageIncrement(10000);
        this.spnFieldOfView.setMaximum(100000000);
        this.spnFieldOfView.setSelection(48234);
        this.spnFieldOfView.setIncrement(1000);
        this.spnFieldOfView.setDigits(3);
        Label lblFieldOfViewUnit = new Label(this.compInScrolled, 0);
        lblFieldOfViewUnit.setText("[deg]");
        this.lblTransmittedPower = new Label(this.compInScrolled, 0);
        GridData gd_lblTransmittedPower = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTransmittedPower.horizontalIndent = 20;
        this.lblTransmittedPower.setLayoutData((Object)gd_lblTransmittedPower);
        this.lblTransmittedPower.setText("Transmitted Power:");
        this.spnTransmittedPower = new Spinner(this.compInScrolled, 2048);
        this.spnTransmittedPower.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnTransmittedPower.setPageIncrement(10000);
        this.spnTransmittedPower.setMaximum(100000000);
        this.spnTransmittedPower.setSelection(48234);
        this.spnTransmittedPower.setIncrement(1000);
        this.spnTransmittedPower.setDigits(3);
        this.lblTransmittedPowerUnit = new Label(this.compInScrolled, 0);
        this.lblTransmittedPowerUnit.setText("[MW]");
        this.lblMinReceivedPower = new Label(this.compInScrolled, 0);
        GridData gd_lblMinReceivedPower = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMinReceivedPower.horizontalIndent = 20;
        this.lblMinReceivedPower.setLayoutData((Object)gd_lblMinReceivedPower);
        this.lblMinReceivedPower.setText("Min. Received Power");
        this.spnMinReceivedPower = new Spinner(this.compInScrolled, 2048);
        this.spnMinReceivedPower.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnMinReceivedPower.setPageIncrement(10000);
        this.spnMinReceivedPower.setMaximum(100000000);
        this.spnMinReceivedPower.setSelection(48234);
        this.spnMinReceivedPower.setIncrement(1000);
        this.spnMinReceivedPower.setDigits(3);
        this.lblMinReceivedPowerUnit = new Label(this.compInScrolled, 0);
        this.lblMinReceivedPowerUnit.setText("[W]");
        this.lblAntennaDishDiameter = new Label(this.compInScrolled, 0);
        GridData gd_lblAntennaDishDiameter = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblAntennaDishDiameter.horizontalIndent = 20;
        this.lblAntennaDishDiameter.setLayoutData((Object)gd_lblAntennaDishDiameter);
        this.lblAntennaDishDiameter.setText("Antenna Dish Diameter:");
        this.spnAntennaDishDiameter = new Spinner(this.compInScrolled, 2048);
        this.spnAntennaDishDiameter.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnAntennaDishDiameter.setPageIncrement(10000);
        this.spnAntennaDishDiameter.setMaximum(100000000);
        this.spnAntennaDishDiameter.setSelection(48234);
        this.spnAntennaDishDiameter.setIncrement(1000);
        this.spnAntennaDishDiameter.setDigits(3);
        this.lblAntennaDishDiameterUnit = new Label(this.compInScrolled, 0);
        this.lblAntennaDishDiameterUnit.setText("[m]");
        this.lblAntennaEfficiencyFactor = new Label(this.compInScrolled, 0);
        GridData gd_lblAntennaEfficiencyFactor = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblAntennaEfficiencyFactor.horizontalIndent = 20;
        this.lblAntennaEfficiencyFactor.setLayoutData((Object)gd_lblAntennaEfficiencyFactor);
        this.lblAntennaEfficiencyFactor.setText("Antenna Efficiency Factor:");
        this.spnAntennaEfficiencyFactor = new Spinner(this.compInScrolled, 2048);
        this.spnAntennaEfficiencyFactor.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnAntennaEfficiencyFactor.setPageIncrement(10000);
        this.spnAntennaEfficiencyFactor.setMaximum(100000000);
        this.spnAntennaEfficiencyFactor.setSelection(48234);
        this.spnAntennaEfficiencyFactor.setIncrement(1000);
        this.spnAntennaEfficiencyFactor.setDigits(3);
        this.lblAntennaEfficiencyFactorUnit = new Label(this.compInScrolled, 0);
        this.lblAntennaEfficiencyFactorUnit.setText("[-]");
        this.lblWaveLength = new Label(this.compInScrolled, 0);
        GridData gd_lblWaveLength = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblWaveLength.horizontalIndent = 20;
        this.lblWaveLength.setLayoutData((Object)gd_lblWaveLength);
        this.lblWaveLength.setText("Wave Length:");
        this.spnWaveLength = new Spinner(this.compInScrolled, 2048);
        this.spnWaveLength.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnWaveLength.setPageIncrement(10000);
        this.spnWaveLength.setMaximum(100000000);
        this.spnWaveLength.setSelection(48234);
        this.spnWaveLength.setIncrement(1000);
        this.spnWaveLength.setDigits(3);
        this.lblWaveLengthUnit = new Label(this.compInScrolled, 0);
        this.lblWaveLengthUnit.setText("[m]");
        this.lblLossDueToDecay = new Label(this.compInScrolled, 0);
        GridData gd_lblLossDueToDecay = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblLossDueToDecay.horizontalIndent = 20;
        this.lblLossDueToDecay.setLayoutData((Object)gd_lblLossDueToDecay);
        this.lblLossDueToDecay.setText("Loss due to Decay (damping):");
        this.lblLossDueToDecay.setToolTipText(EXPLAINATION_OF_LOSSES);
        this.spnLossDueToDecay = new Spinner(this.compInScrolled, 2048);
        this.spnLossDueToDecay.setToolTipText(EXPLAINATION_OF_LOSSES);
        this.spnLossDueToDecay.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnLossDueToDecay.setPageIncrement(10000);
        this.spnLossDueToDecay.setMaximum(100000000);
        this.spnLossDueToDecay.setSelection(48234);
        this.spnLossDueToDecay.setIncrement(1000);
        this.spnLossDueToDecay.setDigits(3);
        this.lblLossDueToDecayUnit = new Label(this.compInScrolled, 0);
        this.lblLossDueToDecayUnit.setText("[-]");
        this.lblLossDueToFluctuation = new Label(this.compInScrolled, 0);
        GridData gd_lblLossDueToFluctuation = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblLossDueToFluctuation.horizontalIndent = 20;
        this.lblLossDueToFluctuation.setLayoutData((Object)gd_lblLossDueToFluctuation);
        this.lblLossDueToFluctuation.setText("Loss due to Fluctuation:");
        this.lblLossDueToFluctuation.setToolTipText(EXPLAINATION_OF_LOSSES);
        this.spnLossDueToFluctuation = new Spinner(this.compInScrolled, 2048);
        this.spnLossDueToFluctuation.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnLossDueToFluctuation.setPageIncrement(10000);
        this.spnLossDueToFluctuation.setMaximum(100000000);
        this.spnLossDueToFluctuation.setSelection(48234);
        this.spnLossDueToFluctuation.setIncrement(1000);
        this.spnLossDueToFluctuation.setDigits(3);
        this.spnLossDueToFluctuation.setToolTipText(EXPLAINATION_OF_LOSSES);
        this.lblLossDueToFluctuationUnit = new Label(this.compInScrolled, 0);
        this.lblLossDueToFluctuationUnit.setText("[-]");
        this.lblLossDueToAtmosphere = new Label(this.compInScrolled, 0);
        GridData gd_lblLossDueToAtmosphere = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblLossDueToAtmosphere.horizontalIndent = 20;
        this.lblLossDueToAtmosphere.setLayoutData((Object)gd_lblLossDueToAtmosphere);
        this.lblLossDueToAtmosphere.setText("Loss due to Atmosphere:");
        this.lblLossDueToAtmosphere.setToolTipText(EXPLAINATION_OF_LOSSES);
        this.spnLossDueToAtmosphere = new Spinner(this.compInScrolled, 2048);
        this.spnLossDueToAtmosphere.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spnLossDueToAtmosphere.setPageIncrement(10000);
        this.spnLossDueToAtmosphere.setMaximum(100000000);
        this.spnLossDueToAtmosphere.setSelection(48234);
        this.spnLossDueToAtmosphere.setIncrement(1000);
        this.spnLossDueToAtmosphere.setDigits(3);
        this.spnLossDueToAtmosphere.setToolTipText(EXPLAINATION_OF_LOSSES);
        this.lblLossDueToAtmosphereUnit = new Label(this.compInScrolled, 0);
        this.lblLossDueToAtmosphereUnit.setText("[-]");
        this.label_1 = new Label(this.compInScrolled, 258);
        GridData gd_label_1 = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_label_1.heightHint = 30;
        this.label_1.setLayoutData((Object)gd_label_1);
        this.lblErrors = new Label(this.compInScrolled, 0);
        this.lblErrors.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.lblErrors.setText("Errors");
        this.label = new Label(this.compInScrolled, 256);
        this.composite_1 = new Composite(this.compInScrolled, 0);
        FillLayout fl_composite_1 = new FillLayout(256);
        fl_composite_1.spacing = 8;
        this.composite_1.setLayout((Layout)fl_composite_1);
        this.composite_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.biasLabel = new Label(this.composite_1, 0);
        this.biasLabel.setAlignment(0x1000000);
        this.biasLabel.setText("Bias");
        this.noiseLabel = new Label(this.composite_1, 0);
        this.noiseLabel.setAlignment(0x1000000);
        this.noiseLabel.setText("Noise");
        this.driftLabel = new Label(this.composite_1, 0);
        this.driftLabel.setAlignment(0x1000000);
        this.driftLabel.setText("Drift");
        new Label(this.compInScrolled, 0);
        this.lblRa = new Label(this.compInScrolled, 0);
        GridData gd_lblRa = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRa.horizontalIndent = 20;
        this.lblRa.setLayoutData((Object)gd_lblRa);
        this.lblRa.setText("RA:");
        this.composite = new Composite(this.compInScrolled, 0);
        FillLayout fl_composite = new FillLayout(256);
        fl_composite.spacing = 8;
        this.composite.setLayout((Layout)fl_composite);
        this.composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.raBiasSpinner = new Spinner(this.composite, 2048);
        this.raBiasSpinner.setPageIncrement(10000);
        this.raBiasSpinner.setMaximum(100000000);
        this.raBiasSpinner.setSelection(48234);
        this.raBiasSpinner.setIncrement(1000);
        this.raBiasSpinner.setDigits(3);
        this.raNoiseSpinner = new Spinner(this.composite, 2048);
        this.raNoiseSpinner.setPageIncrement(10000);
        this.raNoiseSpinner.setMaximum(100000000);
        this.raNoiseSpinner.setSelection(48234);
        this.raNoiseSpinner.setIncrement(1000);
        this.raNoiseSpinner.setDigits(3);
        this.raDriftSpinner = new Spinner(this.composite, 2048);
        this.raDriftSpinner.setPageIncrement(10000);
        this.raDriftSpinner.setMaximum(100000000);
        this.raDriftSpinner.setSelection(48234);
        this.raDriftSpinner.setIncrement(1000);
        this.raDriftSpinner.setDigits(3);
        this.raUnitLabel = new Label(this.compInScrolled, 0);
        this.raUnitLabel.setText("[deg]");
        this.lblDecl = new Label(this.compInScrolled, 0);
        GridData gd_lblDecl = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblDecl.horizontalIndent = 20;
        this.lblDecl.setLayoutData((Object)gd_lblDecl);
        this.lblDecl.setText("Decl.:");
        this.composite_2 = new Composite(this.compInScrolled, 0);
        FillLayout fl_composite_2 = new FillLayout(256);
        fl_composite_2.spacing = 8;
        this.composite_2.setLayout((Layout)fl_composite_2);
        this.composite_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.declBiasSpinner = new Spinner(this.composite_2, 2048);
        this.declBiasSpinner.setPageIncrement(10000);
        this.declBiasSpinner.setMaximum(100000000);
        this.declBiasSpinner.setSelection(48234);
        this.declBiasSpinner.setIncrement(1000);
        this.declBiasSpinner.setDigits(3);
        this.declNoiseSpinner = new Spinner(this.composite_2, 2048);
        this.declNoiseSpinner.setPageIncrement(10000);
        this.declNoiseSpinner.setMaximum(100000000);
        this.declNoiseSpinner.setSelection(48234);
        this.declNoiseSpinner.setIncrement(1000);
        this.declNoiseSpinner.setDigits(3);
        this.declDriftSpinner = new Spinner(this.composite_2, 2048);
        this.declDriftSpinner.setPageIncrement(10000);
        this.declDriftSpinner.setMaximum(100000000);
        this.declDriftSpinner.setSelection(48234);
        this.declDriftSpinner.setIncrement(1000);
        this.declDriftSpinner.setDigits(3);
        this.declUnitLabel = new Label(this.compInScrolled, 0);
        this.declUnitLabel.setText("[deg]");
        this.lblRange = new Label(this.compInScrolled, 0);
        GridData gd_lblRange = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRange.horizontalIndent = 20;
        this.lblRange.setLayoutData((Object)gd_lblRange);
        this.lblRange.setText("Range:");
        this.composite_3 = new Composite(this.compInScrolled, 0);
        FillLayout fl_composite_3 = new FillLayout(256);
        fl_composite_3.spacing = 8;
        this.composite_3.setLayout((Layout)fl_composite_3);
        this.composite_3.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.rangeBiasSpinner = new Spinner(this.composite_3, 2048);
        this.rangeBiasSpinner.setPageIncrement(10000);
        this.rangeBiasSpinner.setMaximum(100000000);
        this.rangeBiasSpinner.setSelection(48234);
        this.rangeBiasSpinner.setIncrement(1000);
        this.rangeBiasSpinner.setDigits(3);
        this.rangeNoiseSpinner = new Spinner(this.composite_3, 2048);
        this.rangeNoiseSpinner.setPageIncrement(10000);
        this.rangeNoiseSpinner.setMaximum(100000000);
        this.rangeNoiseSpinner.setSelection(48234);
        this.rangeNoiseSpinner.setIncrement(1000);
        this.rangeNoiseSpinner.setDigits(3);
        this.rangeDriftSpinner = new Spinner(this.composite_3, 2048);
        this.rangeDriftSpinner.setPageIncrement(10000);
        this.rangeDriftSpinner.setMaximum(100000000);
        this.rangeDriftSpinner.setSelection(48234);
        this.rangeDriftSpinner.setIncrement(1000);
        this.rangeDriftSpinner.setDigits(3);
        this.rangeUnitLabel = new Label(this.compInScrolled, 0);
        this.rangeUnitLabel.setText("[km]");
        this.cmpNote = new Composite(this.compInScrolled, 0);
        GridData gd_cmpNote = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_cmpNote.verticalIndent = 20;
        this.cmpNote.setLayoutData((Object)gd_cmpNote);
        this.cmpNote.setVisible(false);
        this.cmpNote.setLayout((Layout)new GridLayout(2, false));
        this.lblNoteCaption = new Label(this.cmpNote, 0);
        this.lblNoteCaption.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.lblNoteCaption.setText("Note:");
        this.lblNoteCaption.setFont(SWTResourceManager.getFont("Sans Serif", 9, 1));
        this.lblNote = new Label(this.cmpNote, 64);
        GridData gd_lblNote = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_lblNote.widthHint = 100;
        this.lblNote.setLayoutData((Object)gd_lblNote);
        this.lblNote.setText("Designator changes do not affect usages of selected element in sensor network definitions.");
        Group inputFileGroup = new Group(cmpParent, 0);
        inputFileGroup.setEnabled(false);
        inputFileGroup.setText("Radar Sensors Input File");
        GridLayout gl_inputFileGroup = new GridLayout(3, false);
        inputFileGroup.setLayout((Layout)gl_inputFileGroup);
        inputFileGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.inputFileText = new Text((Composite)inputFileGroup, 2048);
        this.inputFileText.setEnabled(false);
        this.inputFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.inputFileText.setText("<radars input file / obssim.rad>");
        this.inputFileBrowseButton = new Button((Composite)inputFileGroup, 0);
        this.inputFileBrowseButton.setEnabled(false);
        this.inputFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.inputFileBrowseButton.setToolTipText("Browse");
        this.inputFileEditButton = new Button((Composite)inputFileGroup, 0);
        this.inputFileEditButton.setEnabled(false);
        this.inputFileEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        this.inputFileEditButton.setToolTipText("Edit");
        scrolledComposite.setContent((Control)this.compInScrolled);
        scrolledComposite.setMinSize(this.compInScrolled.computeSize(-1, -1));
    }

    public void doAdditionalStuff() {
        this.logger.trace("doAdditionalStuff()");
        this.logger.debug("Doing additional stuff");
        Util.setDefaultDoubleAttributes(this.spnAntennaDishDiameter, this.spnAntennaEfficiencyFactor, this.spnFieldOfView, this.spnLossDueToAtmosphere, this.spnLossDueToDecay, this.spnLossDueToFluctuation, this.spnMinReceivedPower, this.spnTransmittedPower, this.spnWaveLength, this.raBiasSpinner, this.raDriftSpinner, this.raNoiseSpinner, this.declBiasSpinner, this.declDriftSpinner, this.declNoiseSpinner, this.rangeBiasSpinner, this.rangeDriftSpinner, this.rangeNoiseSpinner);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RadarSensorsPart.this.obsSimRawRadModule.addRadarTelescope();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RadarSensorsPart.this.obsSimRawRadModule.removeRadarTelescope((RadarSensor)RadarSensorsPart.this.selection.getValue());
            }
        });
        Util.setDefaultDoubleAttributes(this.spnAntennaDishDiameter, this.spnAntennaEfficiencyFactor, this.spnFieldOfView, this.spnLossDueToAtmosphere, this.spnLossDueToDecay, this.spnLossDueToFluctuation, this.spnMinReceivedPower, this.spnTransmittedPower, this.spnWaveLength);
    }

    public void bindGUIElements() {
        this.logger.trace("bindData()");
        this.logger.debug("Binding GUI elements");
        DataBindingContext dbc = new DataBindingContext();
        this.logger.debug("Binding telescopes table viewer");
        Util.bindList(dbc, (InputElement)this.obsSimRawRadModule, "radarTelescopes", "name", this.selection, this.telescopesTableViewer);
        this.logger.debug("Binding designator text");
        Util.bindString(dbc, this.selection, "name", (Control)this.txtName);
        this.logger.debug("Binding spinners");
        Util.bindDouble(dbc, this.selection, "antennaDishDiameter", this.spnAntennaDishDiameter);
        Util.bindDouble(dbc, this.selection, "antennaEfficiencyFactor", this.spnAntennaEfficiencyFactor);
        Util.bindDouble(dbc, this.selection, "fieldOfView", this.spnFieldOfView);
        Util.bindDouble(dbc, this.selection, "lossDueToAtmosphere", this.spnLossDueToAtmosphere);
        Util.bindDouble(dbc, this.selection, "lossDueToDecay", this.spnLossDueToDecay);
        Util.bindDouble(dbc, this.selection, "lossDueToFluctuation", this.spnLossDueToFluctuation);
        Util.bindDouble(dbc, this.selection, "minReceivedPower", this.spnMinReceivedPower);
        Util.bindDouble(dbc, this.selection, "transmittedPower", this.spnTransmittedPower);
        Util.bindDouble(dbc, this.selection, "waveLength", this.spnWaveLength);
        this.logger.debug("Binding input file text");
        Util.bindString(dbc, (ModelElement)this.obsSimRawCfgModule, "radarSensorsInputFile", this.inputFileText);
        this.logger.debug("Binding selection group visibility");
        Util.bindBooleanPropertyToSelectionExistence(dbc, (IObservableValue)WidgetProperties.visible().observe((Widget)this.grpSelection), (ISelectionProvider)this.telescopesTableViewer);
        this.txtName.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RadarSensorsPart.this.cmpNote.setVisible(true);
            }

            public void focusLost(FocusEvent e) {
                RadarSensorsPart.this.cmpNote.setVisible(false);
            }
        });
        Util.bind(dbc, this.selection, "raError", this.selectionRAError);
        Util.bind(dbc, this.selection, "declError", this.selectionDeclError);
        Util.bind(dbc, this.selection, "rangeError", this.selectionRangeError);
        this.bindErrorSpinners(dbc, this.selectionRAError, this.raBiasSpinner, this.raDriftSpinner, this.raNoiseSpinner);
        this.bindErrorSpinners(dbc, this.selectionDeclError, this.declBiasSpinner, this.declDriftSpinner, this.declNoiseSpinner);
        this.bindErrorSpinners(dbc, this.selectionRangeError, this.rangeBiasSpinner, this.rangeDriftSpinner, this.rangeNoiseSpinner);
        Enabler enabler = new Enabler(new Control[]{this.grpSelection, this.telescopesGroup, this.cmpNote});
        enabler.setOutputControlsToBeIgnored(new Control[]{this.removeButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue())) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
        enabler = new Enabler(new Control[]{this.removeButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.addObservable((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.telescopesTableViewer));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue()) && values.getTyped(3) != null) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
    }

    private void bindErrorSpinners(DataBindingContext dbc, WritableValue error, Spinner biasSpinner, Spinner driftSpinner, Spinner noiseSpinner) {
        Util.bindDouble(dbc, error, "bias", biasSpinner);
        Util.bindDouble(dbc, error, "drift", driftSpinner);
        Util.bindDouble(dbc, error, "noise", noiseSpinner);
    }

    public void focus() {
        this.logger.trace("focus()");
        this.telescopesTableViewer.getTable().setFocus();
    }

    public void finalizeCreation() {
        this.logger.trace("finalizeCreation");
        this.logger.debug("Finalizing creation");
        Util.activateScrolling((Control)this.compInScrolled);
    }

    @Inject
    @Optional
    void fixBrokenLayout(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        if (!this.grpSelection.isDisposed()) {
            this.grpSelection.layout();
        }
    }
}

