/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPlotOutputObjectPart;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputPlotVariant;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotOutputObjectPart
implements IPlotOutputObjectPart {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Optional
    @Named(value="differentialPlotFilePath")
    private String differentialPlotFilePath;
    @Inject
    @Optional
    @Named(value="cumulativePlotFilePath")
    private String cumulativePlotFilePath;
    @Inject
    @Optional
    @Named(value="reverseCumulativePlotFilePath")
    private String reverseCumulativePlotFilePath;
    @Inject
    private IEventBroker eventBroker;
    private TabFolder tabFolder;
    private Object differentialPlotTabItem;
    private Object cumulativePlotTabItem;
    private Object reverseCumulativePlotTabItem;
    private List<Painter> painters = new ArrayList<Painter>();

    @Inject
    void setAttributesFromContext() {
        this.logger.trace("setAttributesFromContext");
    }

    @PostConstruct
    void createGUIElements(Composite parentComposite) {
        this.logger.trace("createGUIElements");
        this.logger.debug("Creating GUI elements");
        parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.tabFolder = new TabFolder(parentComposite, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.differentialPlotTabItem = this.createPlotTabItem(this.tabFolder, "Differential", this.differentialPlotFilePath);
        this.cumulativePlotTabItem = this.createPlotTabItem(this.tabFolder, "Cumulative", this.cumulativePlotFilePath);
        this.reverseCumulativePlotTabItem = this.createPlotTabItem(this.tabFolder, "Reverse Cumulative", this.reverseCumulativePlotFilePath);
    }

    private TabItem createPlotTabItem(TabFolder tabFolder, String tabItemName, String plotPicFilePath) {
        this.logger.trace("createPlotTabItem(tabFolder={}, tabItemName={}, plotPicFilePath={})", new Object[]{tabFolder, tabItemName, plotPicFilePath});
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(tabItemName);
        if (plotPicFilePath != null) {
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tabFolder, 768);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            tabItem.setControl((Control)scrolledComposite);
            Canvas canvas = new Canvas((Composite)scrolledComposite, 0);
            canvas.setLayoutData((Object)new GridData(4, 4, true, true));
            scrolledComposite.setContent((Control)canvas);
            Painter painter = new Painter(canvas, plotPicFilePath);
            this.painters.add(painter);
            scrolledComposite.setMinSize(new Point(painter.getImage().getBounds().width, painter.getImage().getBounds().height));
        }
        return tabItem;
    }

    public void doAdditionalStuff() {
        this.logger.trace("doAdditionalStuff");
        this.logger.debug("Doing additional stuff");
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPlotVariant selectedPlotType = null;
                selectedPlotType = e.item == PlotOutputObjectPart.this.differentialPlotTabItem ? OutputPlotVariant.DIFFERENTIAL : (e.item == PlotOutputObjectPart.this.cumulativePlotTabItem ? OutputPlotVariant.CUMULATIVE : OutputPlotVariant.REVERSE_CUMULATIVE);
                PlotOutputObjectPart.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/plotPictureSelected", (Object)selectedPlotType);
            }
        });
    }

    public void bindGUIElements() {
        this.logger.trace("bindGUIElements");
        this.logger.debug("Binding GUI elements");
    }

    public void focus() {
        this.logger.trace("focus");
        this.tabFolder.setFocus();
    }

    @Inject
    @Optional
    void onOutputDestroyEvent(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/destroy") Event event) {
        this.logger.trace("onOutputDestroyEvent(..)");
        for (Painter painter : this.painters) {
            painter.deleteImage();
        }
    }

    public void finalizeCreation() {
        this.logger.trace("finalizeCreation");
        this.logger.debug("Finalizing creation");
    }

    public void reloadPlots() {
        this.logger.trace("reloadPlots()");
        for (Painter painter : this.painters) {
            painter.reloadImage();
        }
    }

    class Painter
    implements PaintListener {
        private Logger logger;
        private volatile Image image;
        private String plotPicFilePath;
        private Canvas canvas;
        private volatile boolean paintingEnabled = false;
        private volatile boolean painting = false;

        public Painter(Canvas canvas, String plotPicFilePath) {
            String fileName = FileSystems.getDefault().getPath(plotPicFilePath, new String[0]).getFileName().toString();
            this.logger = LoggerFactory.getLogger((String)(this.getClass() + "[" + fileName + "]"));
            this.logger.trace("Painter(...)");
            this.canvas = canvas;
            this.plotPicFilePath = plotPicFilePath;
            this.logger.debug("Getting image");
            this.image = ResourceManager.getImage(plotPicFilePath);
            this.logger.debug("Enabling painting");
            this.paintingEnabled = true;
            this.logger.debug("Adding myself as PaintListener");
            this.canvas.addPaintListener((PaintListener)this);
        }

        public void paintControl(PaintEvent e) {
            this.logger.trace("paintControl(..)");
            if (!this.paintingEnabled) {
                this.logger.debug("Painting disabled - skipping");
                return;
            }
            this.painting = true;
            this.logger.debug("Painting background");
            Color white = Display.getDefault().getSystemColor(1);
            e.gc.setBackground(white);
            e.gc.fillRectangle(this.canvas.getClientArea());
            this.logger.debug("Determining image paint coordinates");
            int x = this.canvas.getClientArea().width > this.image.getBounds().width ? (this.canvas.getClientArea().width - this.image.getBounds().width) / 2 : 0;
            int y = this.canvas.getClientArea().height > this.image.getBounds().height ? (this.canvas.getClientArea().height - this.image.getBounds().height) / 2 : 0;
            this.logger.debug("Painting image");
            e.gc.drawImage(this.image, x, y);
            this.painting = false;
        }

        public Image getImage() {
            return this.image;
        }

        public void reloadImage() {
            this.logger.trace("reloadImage()");
            this.logger.debug("Disabling painting");
            this.paintingEnabled = false;
            this.logger.debug("Waiting for painting to stop");
            while (this.painting) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.deleteImage();
            this.logger.debug("Loading image");
            this.image = ResourceManager.getImage(this.plotPicFilePath);
            this.logger.debug("Enabling painting");
            this.paintingEnabled = true;
            this.logger.debug("Triggering repainting");
            this.canvas.redraw();
            this.canvas.update();
        }

        public void deleteImage() {
            this.logger.trace("deleteImage()");
            this.logger.debug("Deleting image");
            ResourceManager.disposeImage(this.plotPicFilePath);
        }
    }
}

