/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs.ButtonType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs.NEOPOPDialog;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.service.event.Event;

public class RunDialog
extends NEOPOPDialog {
    private Shell shell = new Shell(this.getParent(), 67680);
    private ExpandStuff outputExpandStuff;
    private Button closeButton;
    private ProgressBar progressBar;
    private Label statusLabel;
    private Composite progressBarComposite;
    private ExpandStuff errorLogExpandStuff;
    private Button cancelButton;
    private volatile boolean projectRunCompleted = false;
    private Button liveLogButton;
    private boolean isLiveLog = true;

    public RunDialog() {
        this.shell.setSize(new Point(855, 200));
        this.shell.setText("Run NEOPOP");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.statusLabel = new Label((Composite)this.shell, 0);
        this.statusLabel.setAlignment(0x1000000);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.statusLabel.setText("Running NEOPOP...");
        this.progressBarComposite = new Composite((Composite)this.shell, 0);
        this.progressBarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.progressBarComposite.setLayout((Layout)new FillLayout(256));
        this.progressBar = new ProgressBar(this.progressBarComposite, 2);
        Composite buttonsComposite = new Composite((Composite)this.shell, 0);
        buttonsComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        this.cancelButton = new Button(buttonsComposite, 0);
        GridData gd_cancelButton = new GridData(4, 4, false, false, 1, 1);
        gd_cancelButton.heightHint = 20;
        gd_cancelButton.widthHint = 125;
        this.cancelButton.setLayoutData((Object)gd_cancelButton);
        this.cancelButton.setText("Cancel Execution");
        this.cancelButton.addSelectionListener((SelectionListener)new NEOPOPDialog.ButtonPressListener(ButtonType.CANCEL));
        this.cancelButton.setToolTipText("Cancel running execution");
        this.liveLogButton = new Button(buttonsComposite, 0);
        this.liveLogButton.setEnabled(true);
        GridData gd_liveLogButton = new GridData(4, 4, false, false, 1, 1);
        gd_liveLogButton.widthHint = 125;
        this.liveLogButton.setLayoutData((Object)gd_liveLogButton);
        this.liveLogButton.setText("Block Live Log");
        this.liveLogButton.addSelectionListener((SelectionListener)new NEOPOPDialog.ButtonPressListener(ButtonType.LIVE_LOG));
        this.liveLogButton.setToolTipText("Block automatic scroll down when receiving new messages");
        this.closeButton = new Button(buttonsComposite, 0);
        this.closeButton.setEnabled(false);
        GridData gd_closeButton = new GridData(4, 4, false, false, 1, 1);
        gd_closeButton.widthHint = 125;
        this.closeButton.setLayoutData((Object)gd_closeButton);
        this.closeButton.setText("Close");
        this.closeButton.addSelectionListener((SelectionListener)new NEOPOPDialog.ButtonPressListener(ButtonType.CLOSE));
        this.closeButton.setToolTipText("Close RunDialog");
        ExpandBar expandBar = new ExpandBar((Composite)this.shell, 0);
        expandBar.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.outputExpandStuff = this.createExpandStuff(expandBar, "Show Log");
        this.errorLogExpandStuff = this.createExpandStuff(expandBar, "Show Error Log");
        expandBar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemExpanded(ExpandEvent e) {
                if (e.item == ((RunDialog)RunDialog.this).outputExpandStuff.expandItem) {
                    ((RunDialog)RunDialog.this).errorLogExpandStuff.expandItem.setExpanded(false);
                } else {
                    ((RunDialog)RunDialog.this).outputExpandStuff.expandItem.setExpanded(false);
                }
                RunDialog.this.shell.setSize(855, 460);
                RunDialog.this.shell.layout();
            }

            public void itemCollapsed(ExpandEvent e) {
                RunDialog.this.shell.setSize(855, 200);
            }
        });
        this.outputExpandStuff.expandItem.setExpanded(true);
        this.shell.setSize(855, 460);
        this.shell.layout();
        this.shell.addListener(21, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                RunDialog.this.logger.trace("handleEvent(event={})", (Object)event);
                if (!RunDialog.this.projectRunCompleted && !RunDialog.this.confirmAndRealizeCancellation()) {
                    event.doit = false;
                }
            }
        });
    }

    private ExpandStuff createExpandStuff(ExpandBar expandBar, String expandItemText) {
        ExpandStuff result = new ExpandStuff();
        result.expandItem = new ExpandItem(expandBar, 0);
        result.expandItem.setText(expandItemText);
        Composite composite = new Composite((Composite)expandBar, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        result.textField = new StyledText(composite, 2826);
        result.textField.setFont(SWTResourceManager.getFont("Courier", 9, 0));
        GridData textFieldGridData = new GridData(4, 4, true, true, 1, 1);
        textFieldGridData.heightHint = 240;
        result.textField.setLayoutData((Object)textFieldGridData);
        result.expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        result.expandItem.setControl((Control)composite);
        return result;
    }

    @Override
    public void open() {
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    protected void process(ButtonType button) {
        switch (button) {
            case CLOSE: {
                this.dispose();
                break;
            }
            case CANCEL: {
                this.confirmAndRealizeCancellation();
                break;
            }
            case LIVE_LOG: {
                if (this.isLiveLog) {
                    this.liveLogButton.setText("Unblock Live Log");
                    this.liveLogButton.setToolTipText("Turn on automatic scrolling down when receiving new messages");
                    this.isLiveLog = false;
                    break;
                }
                this.liveLogButton.setText("Block Live Log");
                this.liveLogButton.setToolTipText("Turn off automatic scrolling down when receiving new messages");
                this.outputExpandStuff.textField.setTopIndex(this.outputExpandStuff.textField.getLineCount() - 1);
                this.outputExpandStuff.textField.setHorizontalIndex(0);
                this.isLiveLog = true;
            }
        }
    }

    protected boolean confirmAndRealizeCancellation() {
        this.logger.trace("cancelRequested");
        if (MessageDialog.openQuestion((Shell)this.shell, (String)"Cancel Execution?", (String)"Are you sure you want to cancel execution of NEOPOP?")) {
            this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/runCancellationRequested", null);
            return true;
        }
        return false;
    }

    @Override
    protected void saveAndLogContents() {
    }

    @Inject
    @Optional
    void neopopCLTExecutionCompleted(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/neopopCLTExecutionCompleted") Event event, UISynchronize uiSynch) {
        this.logger.trace("neopopCLTExecutionCompleted");
        uiSynch.asyncExec(new Runnable(){

            @Override
            public void run() {
                RunDialog.this.logger.trace("run()");
                RunDialog.this.logger.debug("Updating status label");
                if (!RunDialog.this.statusLabel.isDisposed()) {
                    RunDialog.this.statusLabel.setText("Processing results...");
                }
            }
        });
    }

    @Inject
    @Optional
    void projectRunCompleted(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/projectRunCompleted") Event event, UISynchronize uiSynch) {
        this.logger.trace("projectRunCompleted");
        this.projectRunCompleted = true;
        uiSynch.asyncExec(new Runnable(){

            @Override
            public void run() {
                RunDialog.this.logger.trace("run()");
                RunDialog.this.logger.debug("Updating status label, progress bar and close button");
                if (!RunDialog.this.statusLabel.isDisposed()) {
                    RunDialog.this.statusLabel.setText("NEOPOP run completed.");
                }
                if (!RunDialog.this.progressBar.isDisposed()) {
                    RunDialog.this.progressBar.dispose();
                    RunDialog.this.progressBar = new ProgressBar(RunDialog.this.progressBarComposite, 0);
                    RunDialog.this.progressBar.setSelection(100);
                    RunDialog.this.progressBarComposite.layout();
                }
                if (!RunDialog.this.closeButton.isDisposed()) {
                    RunDialog.this.closeButton.setEnabled(true);
                }
                if (!RunDialog.this.cancelButton.isDisposed()) {
                    RunDialog.this.cancelButton.setEnabled(false);
                }
                if (!RunDialog.this.liveLogButton.isDisposed()) {
                    RunDialog.this.liveLogButton.setEnabled(false);
                }
            }
        });
    }

    @Inject
    @Optional
    void showNEOPOPOutputLine(final @EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/caughtNEOPOPOutputLine") String line, UISynchronize uiSynch) {
        this.logger.trace("showNEOPOPOutputLine");
        this.logger.debug("Showing NEOPOP output line: {}", (Object)line);
        uiSynch.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!((RunDialog)RunDialog.this).outputExpandStuff.textField.isDisposed()) {
                    ((RunDialog)RunDialog.this).outputExpandStuff.textField.append("\n" + line);
                    if (RunDialog.this.isLiveLog) {
                        ((RunDialog)RunDialog.this).outputExpandStuff.textField.setTopIndex(((RunDialog)RunDialog.this).outputExpandStuff.textField.getLineCount() - 1);
                        ((RunDialog)RunDialog.this).outputExpandStuff.textField.setHorizontalIndex(0);
                    }
                }
            }
        });
    }

    @Inject
    @Optional
    void showNEOPOPRemainingTime(final @EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/caughtNEOPOPRemainTime") String line, UISynchronize uiSynch) {
        uiSynch.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!RunDialog.this.statusLabel.isDisposed() && line.contains("remaining time is")) {
                    RunDialog.this.statusLabel.setText("Running NEOPOP... (" + line + ")");
                }
            }
        });
    }

    @Inject
    @Optional
    void showErrorLog(final @EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/readErrorLog") String errorLog, UISynchronize uiSynch) {
        this.logger.trace("showErrorLog");
        this.logger.debug("Showing error log: {}", (Object)errorLog);
        uiSynch.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!((RunDialog)RunDialog.this).errorLogExpandStuff.expandItem.isDisposed()) {
                    ((RunDialog)RunDialog.this).errorLogExpandStuff.expandItem.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui", "icons/open_icon_library/emblem-important-2.png"));
                }
                if (!((RunDialog)RunDialog.this).errorLogExpandStuff.textField.isDisposed()) {
                    ((RunDialog)RunDialog.this).errorLogExpandStuff.textField.setText(String.valueOf(((RunDialog)RunDialog.this).errorLogExpandStuff.textField.getText()) + "\n" + errorLog);
                    ((RunDialog)RunDialog.this).errorLogExpandStuff.textField.getHorizontalBar().setSelection(0);
                }
            }
        });
    }

    class ExpandStuff {
        public StyledText textField;
        public ExpandItem expandItem;

        ExpandStuff() {
        }
    }
}

