/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.HeteroList;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.IAggregationEquation;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElementValue;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.observable.value.WritableValue;

public class ObservableValueAggregator
extends AbstractObservableValue
implements IValueChangeListener,
IDisposeListener {
    private List<IObservableValue> inputObservables = new ArrayList<IObservableValue>();
    private Object oldOutputValue;
    private Object newOutputValue;
    private IAggregationEquation equation = IAggregationEquation.AND_BOOLEANS;

    public ObservableValueAggregator(ModelElementValue ... inputValues) {
        ModelElementValue[] modelElementValueArray = inputValues;
        int n = inputValues.length;
        int n2 = 0;
        while (n2 < n) {
            ModelElementValue inputValue = modelElementValueArray[n2];
            this.addObservable(BeanProperties.value((String)inputValue.getProperty()).observe((Object)inputValue.getModelElement()));
            ++n2;
        }
    }

    public Object getValueType() {
        return Object.class;
    }

    protected Object doGetValue() {
        ArrayList<Object> inputValues = new ArrayList<Object>();
        for (IObservableValue inputObservable : this.inputObservables) {
            inputValues.add(inputObservable.getValue());
        }
        return this.equation.aggregate(new HeteroList(inputValues));
    }

    public void handleDispose(DisposeEvent event) {
        for (IObservableValue value : this.inputObservables) {
            value.removeValueChangeListener((IValueChangeListener)this);
            value.removeDisposeListener((IDisposeListener)this);
        }
    }

    public void handleValueChange(ValueChangeEvent event) {
        this.oldOutputValue = this.newOutputValue;
        this.newOutputValue = this.getValue();
        this.fireValueChange(new ValueDiff(){

            public Object getOldValue() {
                return ObservableValueAggregator.this.oldOutputValue;
            }

            public Object getNewValue() {
                return ObservableValueAggregator.this.newOutputValue;
            }
        });
    }

    public void setAggregationEquation(IAggregationEquation eq) {
        this.equation = eq;
    }

    public void addObservable(IObservableValue value) {
        this.inputObservables.add(value);
        value.addValueChangeListener((IValueChangeListener)this);
        value.addDisposeListener((IDisposeListener)this);
    }

    public void addWritableValue(WritableValue writableValue, String property) {
        this.addObservable(BeanProperties.value((String)property).observeDetail((IObservableValue)writableValue));
    }
}

