/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model.internal;

import de.tu_bs.ilr.esa.estec.neopop.model.CompleteVarIndexes;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.IModelConnector;
import de.tu_bs.ilr.esa.estec.neopop.model.internal.VarDataType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ChoiceVarDataType<T extends Enum<?>>
extends VarDataType<T> {
    private boolean zeroAllowed;
    private Enum<?>[] enumValues;

    public ChoiceVarDataType(Class<T> enumClass, boolean zeroAllowed) {
        super(enumClass);
        this.logger.trace("ChoiceVarDataType(enumClass={}, zeroAllowed={})", enumClass, (Object)zeroAllowed);
        this.zeroAllowed = zeroAllowed;
        Method valuesMethod = null;
        try {
            valuesMethod = enumClass.getDeclaredMethod("values", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.logger.error("Could not get enum values method");
            throw new RuntimeException(e);
        }
        try {
            this.enumValues = (Enum[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Could not invoke enum values method");
            throw new RuntimeException(e);
        }
    }

    @Override
    protected T doGet(IModelConnector connector, String id, CompleteVarIndexes indexes) {
        int resultOrdinal;
        this.logger.trace("doGet(connector={}, id={}, indexes={})", new Object[]{connector, id, indexes});
        int intResult = connector.get_integer(id, indexes.get(0), indexes.get(1));
        if (intResult < 0 && intResult != -999999 || !this.zeroAllowed && intResult == 0) {
            this.logger.error("Could not get {}{}: Got unexpected int result: {}", new Object[]{id, indexes, intResult});
            throw new RuntimeException();
        }
        if (intResult == -999999) {
            return null;
        }
        int n = resultOrdinal = this.zeroAllowed ? intResult : intResult - 1;
        if (resultOrdinal < 0 || resultOrdinal > this.enumValues.length - 1) {
            this.logger.error("Could not get {}{}: Got out-of-range enum ordinal: {}", new Object[]{id, indexes, intResult});
            throw new RuntimeException();
        }
        Enum<?> result = this.enumValues[resultOrdinal];
        this.logger.trace("result={}", result);
        return (T)result;
    }

    @Override
    protected void doSet(IModelConnector connector, String id, CompleteVarIndexes indexes, T value) {
        this.logger.trace("doSet(connector={}, id={}, indexes={}, value={})", new Object[]{connector, id, indexes, value});
        int ordinal = -999999;
        if (value != null) {
            ordinal = ((Enum)value).ordinal();
            if (!this.zeroAllowed) {
                ++ordinal;
            }
        }
        connector.set_integer(id, ordinal, indexes.get(0), indexes.get(1));
    }

    @Override
    protected int doCheck(IModelConnector connector, String id, CompleteVarIndexes indexes, T value) {
        this.logger.trace("doCheck(connector={}, id={}, indexes={}, value={})", new Object[]{connector, id, indexes, value});
        int ordinal = -999999;
        if (value != null) {
            ordinal = ((Enum)value).ordinal();
            if (!this.zeroAllowed) {
                ++ordinal;
            }
        }
        int result = connector.check_integer(id, ordinal, indexes.get(0), indexes.get(1));
        this.logger.trace("result={}", (Object)result);
        return result;
    }
}

