/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RedirectToLogOnRequestPrintStream
extends PrintStream {
    private Map<Thread, Boolean> redirect = Collections.synchronizedMap(new HashMap());
    private PrintStream logPrintStream = null;
    private PipedOutputStream logStreamOutPipe = new PipedOutputStream();

    public RedirectToLogOnRequestPrintStream(final PrintStream targetPrintStream) throws IOException {
        super(targetPrintStream, true);
        this.logPrintStream = new PrintStream(this.logStreamOutPipe);
        PipedInputStream logStreamInPipe = new PipedInputStream(this.logStreamOutPipe);
        final BufferedReader logStreamReader = new BufferedReader(new InputStreamReader(logStreamInPipe));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line = logStreamReader.readLine();
                    while (line != null) {
                        targetPrintStream.println("LOG: " + line);
                        targetPrintStream.flush();
                        line = logStreamReader.readLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
    }

    public void redirectOutputOfCurrentThread(boolean doRedirect) {
        this.redirect.put(Thread.currentThread(), doRedirect);
    }

    public boolean redirectOutputOfCurrentThread() {
        if (!this.redirect.containsKey(Thread.currentThread())) {
            return false;
        }
        return this.redirect.get(Thread.currentThread());
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (this.redirectOutputOfCurrentThread()) {
            this.logPrintStream.write(buf, off, len);
        } else {
            super.write(buf, off, len);
        }
    }

    @Override
    public void write(int b) {
        if (this.redirectOutputOfCurrentThread()) {
            this.logPrintStream.write(b);
        } else {
            super.write(b);
        }
    }

    @Override
    public void println(String x) {
        if (this.redirectOutputOfCurrentThread()) {
            this.logPrintStream.println(x);
        } else {
            super.println(x);
        }
    }

    @Override
    public void close() {
        super.close();
        this.logPrintStream.close();
    }
}

