/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import de.tu_bs.ilr.esa.estec.neopop.model.GUIInterfacePart;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElementCreator;
import de.tu_bs.ilr.esa.estec.neopop.model.InputPlotListContainer;
import de.tu_bs.ilr.esa.estec.neopop.model.PopGen2DPlot;
import de.tu_bs.ilr.esa.estec.neopop.model.PopGen3DPlot;
import de.tu_bs.ilr.esa.estec.neopop.model.PopGenScatterPlot;
import de.tu_bs.ilr.esa.estec.neopop.model.VarUsage;
import de.tu_bs.ilr.esa.estec.neopop.model.Vars;
import java.util.List;

public class PopGenInpPltModule
extends InputElement {
    public static final String PROP_2D_PLOTS = "2dPlots";
    public static final String PROP_3D_PLOTS = "3dPlots";
    public static final String PROP_SCATTER_PLOTS = "scatterPlots";
    public static final String PROP_DRAW_SOLAR_SYSTEM_PLOT_AXES = "drawSolarSystemPlotAxes";
    public static final String PROP_PLOT_SOURCES_IN_2D_PLOTS = "plotSourcesIn2DPlots";
    public static final int NUMBER_OF_PLOTS = 15;
    private InputPlotListContainer<PopGen2DPlot> _2dPlots;
    private InputPlotListContainer<PopGen3DPlot> _3dPlots;
    private InputPlotListContainer<PopGenScatterPlot> scatterPlots;
    private VarUsage<Boolean> drawSolarSystemPlotAxes;
    private VarUsage<Boolean> plotSourcesIn2DPlots;

    protected PopGenInpPltModule(Input parent) {
        super(GUIInterfacePart.POPGEN, parent, new int[0]);
        final PopGenInpPltModule module = this;
        this._2dPlots = new InputPlotListContainer<PopGen2DPlot>(this, 15, new InputElementCreator<PopGen2DPlot>(){

            @Override
            public PopGen2DPlot create(int additionalIndex) {
                return new PopGen2DPlot((InputElement)module, additionalIndex);
            }
        }, PROP_2D_PLOTS);
        this._3dPlots = new InputPlotListContainer<PopGen3DPlot>(this, 15, new InputElementCreator<PopGen3DPlot>(){

            @Override
            public PopGen3DPlot create(int additionalIndex) {
                return new PopGen3DPlot((InputElement)module, additionalIndex);
            }
        }, PROP_3D_PLOTS);
        this.scatterPlots = new InputPlotListContainer<PopGenScatterPlot>(this, 15, new InputElementCreator<PopGenScatterPlot>(){

            @Override
            public PopGenScatterPlot create(int additionalIndex) {
                return new PopGenScatterPlot((InputElement)module, additionalIndex);
            }
        }, PROP_SCATTER_PLOTS);
        this.drawSolarSystemPlotAxes = new VarUsage<Boolean>((InputElement)this, Vars.POPGEN_SW_PLT_DRAW_SOLAR_SYSTEM_PLOT_AXES, PROP_DRAW_SOLAR_SYSTEM_PLOT_AXES, new int[0]);
        this.plotSourcesIn2DPlots = new VarUsage<Boolean>((InputElement)this, Vars.POPGEN_SW_PLT_SRC_SWITCH, PROP_PLOT_SOURCES_IN_2D_PLOTS, new int[0]);
    }

    public List<PopGen2DPlot> get2dPlots() {
        return this._2dPlots.get();
    }

    public PopGen2DPlot add2dPlot() {
        return (PopGen2DPlot)this._2dPlots.add();
    }

    public void remove2dPlot(PopGen2DPlot value) {
        this._2dPlots.remove(value);
    }

    public List<PopGen3DPlot> get3dPlots() {
        return this._3dPlots.get();
    }

    public PopGen3DPlot add3dPlot() {
        return (PopGen3DPlot)this._3dPlots.add();
    }

    public void remove3dPlot(PopGen3DPlot value) {
        this._3dPlots.remove(value);
    }

    public List<PopGenScatterPlot> getScatterPlots() {
        return this.scatterPlots.get();
    }

    public PopGenScatterPlot addScatterPlot() {
        return (PopGenScatterPlot)this.scatterPlots.add();
    }

    public void removeScatterPlot(PopGenScatterPlot value) {
        this.scatterPlots.remove(value);
    }

    public Boolean getDrawSolarSystemPlotAxes() {
        return this.drawSolarSystemPlotAxes.get();
    }

    public void setDrawSolarSystemPlotAxes(Boolean drawSolarSystemPlotAxes) {
        this.drawSolarSystemPlotAxes.set(drawSolarSystemPlotAxes);
    }

    public boolean checkDrawSolarSystemPlotAxes(Boolean drawSolarSystemPlotAxes) {
        return this.drawSolarSystemPlotAxes.check(drawSolarSystemPlotAxes);
    }

    public Boolean getPlotSourcesIn2DPlots() {
        return this.plotSourcesIn2DPlots.get();
    }

    public void setPlotSourcesIn2DPlots(Boolean plotSourcesIn2DPlots) {
        this.plotSourcesIn2DPlots.set(plotSourcesIn2DPlots);
    }

    public boolean checkPlotSourcesIn2DPlots(Boolean plotSourcesIn2DPlots) {
        return this.plotSourcesIn2DPlots.check(plotSourcesIn2DPlots);
    }
}

