/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.handlers;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.PartType;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsButtonHandler {
    @Inject
    private IEventBroker eventBroker;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private PartType visibleSettingsPart = null;

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    public void select(@Named(value="org.eclipse.ui.selection") PartType selectedSettings, ESelectionService selService) {
        this.logger.trace("select");
        this.logger.debug("sel: {}", selService.getSelection(PartType.SETTINGS_OVERVIEW.getID()));
    }

    @Inject
    @Optional
    public void processEvent(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/settings/select") PartType selectedSettings, EModelService modelService, MApplication app, EPartService partService) {
        this.logger.trace("processEvent");
        this.doExecute(selectedSettings, modelService, app, partService);
    }

    public void doExecute(PartType selectedSettingsPart, EModelService modelService, MApplication app, EPartService partService) {
        this.logger.trace("doExecute");
        this.logger.debug("User selected {}", (Object)selectedSettingsPart);
        if (this.visibleSettingsPart == null && selectedSettingsPart == null || this.visibleSettingsPart != null && selectedSettingsPart != null && selectedSettingsPart.equals((Object)this.visibleSettingsPart)) {
            this.logger.debug("{} already selected - skipping");
            return;
        }
        if (selectedSettingsPart != null) {
            MPart mpartToMakeVisible = partService.findPart(selectedSettingsPart.getID());
            if (mpartToMakeVisible == null) {
                this.logger.error("Could not find part {} in application model", (Object)selectedSettingsPart.getID());
                return;
            }
            this.logger.debug("Making part {} visible", (Object)mpartToMakeVisible.getElementId());
            mpartToMakeVisible.setVisible(true);
            partService.showPart(mpartToMakeVisible, EPartService.PartState.VISIBLE);
        }
        if (this.visibleSettingsPart != null) {
            this.logger.debug("Making part {} invisible", (Object)this.visibleSettingsPart.getID());
            MPart mpartToMakeInvisible = partService.findPart(this.visibleSettingsPart.getID());
            partService.hidePart(mpartToMakeInvisible);
            mpartToMakeInvisible.setVisible(false);
        }
        this.visibleSettingsPart = selectedSettingsPart;
    }

    @Inject
    @Optional
    void onGUIStartUp(@EventTopic(value="org/osgi/framework/ServiceEvent/MODIFIED") Event event, EModelService modelService, MApplication app) {
        this.logger.trace("onGUIStartUp(...)");
        this.logger.debug("Checking for Settings Part selected in a previous NEOPOP GUI run");
        MPartStack settingsPartStack = (MPartStack)modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partstacks.settings.selection", MPartStack.class, null).get(0);
        List settingsStackElements = settingsPartStack.getChildren();
        for (MStackElement settingsStackElement : settingsStackElements) {
            MPart settingsPart;
            if (!(settingsStackElement instanceof MPart) || !(settingsPart = (MPart)settingsStackElement).isVisible()) continue;
            this.logger.debug("Noticing that Settings Part {} is visible since the user selected it in a previous NEOPOP GUI run", (Object)settingsPart.getElementId());
            this.visibleSettingsPart = PartType.getByID((String)settingsPart.getElementId());
            this.eventBroker.post("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/settings/select", (Object)this.visibleSettingsPart);
            break;
        }
    }
}

