/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCopyFileVisitor
extends SimpleFileVisitor<Path> {
    public static final String[] excludedFileNamesArray = new String[]{"data", "neopop", "neopop-linux32", "neopop-linux64", "neopop-windows32.exe", "neopop-windows64.exe", "neopop-gfortran32", "neopop-gfortran64"};
    private static List<String> excludedFileNames = Arrays.asList(excludedFileNamesArray);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Path sourceProjDirPath;
    private Path targetProjDirPath;

    public ProjectCopyFileVisitor(Path sourceProjDirPath, Path targetProjDirPath) {
        this.sourceProjDirPath = sourceProjDirPath;
        this.targetProjDirPath = targetProjDirPath;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes attrs) throws IOException {
        if (dirPath.endsWith("data")) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        this.copy(dirPath);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
        if (!excludedFileNames.contains(filePath.getFileName().toString())) {
            this.copy(filePath);
        }
        return FileVisitResult.CONTINUE;
    }

    private void copy(Path path) throws IOException {
        Path targetDirPath = this.targetProjDirPath.resolve(this.sourceProjDirPath.relativize(path));
        if (targetDirPath.toFile().exists() && targetDirPath.equals(this.targetProjDirPath)) {
            return;
        }
        this.logger.debug("Copying {} to {}", (Object)path, (Object)targetDirPath);
        Files.copy(path, targetDirPath, new CopyOption[0]);
        targetDirPath.toFile().setWritable(true);
    }
}

